/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.settings;

import com.minimap.XaeroMinimap;
import com.minimap.events.ControlsHandler;
import com.minimap.gui.GuiSlimeSeed;
import com.minimap.interfaces.Interface;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.minimap.Minimap;
import com.minimap.minimap.Waypoint;
import com.minimap.minimap.WaypointSet;
import com.minimap.minimap.WaypointWorld;
import com.minimap.mods.SupportMods;
import com.minimap.settings.ModOptions;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.integrated.IntegratedServer;

public class ModSettings {
    public static final int defaultSettings = Integer.MAX_VALUE;
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    private static boolean keysLoaded;
    public static final String[] ENCHANT_COLORS;
    public static final String[] ENCHANT_COLOR_NAMES;
    public static final int[] COLORS;
    public static final String[] MINIMAP_SIZE;
    public static int serverSettings;
    public static KeyBinding keyBindSettings;
    public static KeyBinding keyBindZoom;
    public static KeyBinding keyBindZoom1;
    public static KeyBinding newWaypoint;
    public static KeyBinding keyWaypoints;
    public static KeyBinding keyLargeMap;
    public static KeyBinding keyToggleMap;
    public static KeyBinding keyToggleWaypoints;
    public static KeyBinding keyToggleSlimes;
    public static KeyBinding keyToggleGrid;
    public static KeyBinding keyInstantWaypoint;
    private boolean minimap = true;
    public int zoom = 2;
    public float[] zooms = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    public int entityAmount = 1;
    private boolean showPlayers = true;
    private boolean showMobs = true;
    private boolean showHostile = true;
    private boolean showItems = true;
    private boolean showOther = true;
    private boolean caveMaps = true;
    private boolean showOtherTeam = true;
    private boolean showWaypoints = true;
    private boolean deathpoints = true;
    private boolean oldDeathpoints = true;
    public int chunkGrid = -5;
    private boolean slimeChunks = false;
    private static HashMap<String, Long> serverSlimeSeeds;
    private boolean showIngameWaypoints = true;
    private boolean showCoords = true;
    private boolean lockNorth = false;
    private boolean antiAliasing = true;
    public boolean displayRedstone = true;
    public boolean mapSafeMode = false;
    public int distance = 1;
    public static final String[] distanceTypes;
    public int blockColours = 0;
    public static final String[] blockColourTypes;
    public boolean lighting = true;
    public boolean compassOverWaypoints = false;
    private int mapSize = -1;
    public int playersColor = 15;
    public int mobsColor = 14;
    public int hostileColor = 14;
    public int itemsColor = 12;
    public int otherColor = 5;
    public int otherTeamColor = -1;
    public float minimapOpacity = 100.0f;
    public float waypointsScale = 1.0f;
    public float dotsScale = 1.0f;
    public static boolean settingsButton;
    public boolean showBiome = false;
    public static boolean updateNotification;
    public boolean showEntityHeight = true;
    public boolean showFlowers = true;
    public boolean keepWaypointNames = false;
    public float waypointsDistance = 0.0f;
    public float waypointsDistanceMin = 0.0f;
    public String waypointTp = "tp";
    public float arrowScale = 1.5f;
    public int arrowColour = 0;
    public String[] arrowColourNames = new String[]{"gui.xaero_red", "gui.xaero_green", "gui.xaero_blue", "gui.xaero_yellow", "gui.xaero_purple", "gui.xaero_white", "gui.xaero_black", "gui.xaero_preset_classic"};
    public float[][] arrowColours = new float[][]{{0.8f, 0.1f, 0.1f, 1.0f}, {0.09f, 0.57f, 0.0f, 1.0f}, {0.0f, 0.55f, 1.0f, 1.0f}, {1.0f, 0.93f, 0.0f, 1.0f}, {0.73f, 0.33f, 0.83f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {0.4588f, 0.0f, 0.0f, 1.0f}};
    public boolean smoothDots = true;

    public ModSettings() {
        if (!keysLoaded) {
            XaeroMinimap.ch = new ControlsHandler();
            keysLoaded = true;
        }
    }

    public static boolean isKeyRepeat(KeyBinding kb) {
        return kb != keyWaypoints && kb != keyBindSettings && kb != newWaypoint && kb != keyLargeMap && kb != keyToggleMap && kb != keyToggleWaypoints && kb != keyToggleSlimes && kb != keyToggleGrid && kb != keyInstantWaypoint;
    }

    public boolean getMinimap() {
        return this.minimap && !this.minimapDisabled();
    }

    public boolean getShowPlayers() {
        return this.showPlayers && !this.minimapDisplayPlayersDisabled();
    }

    public boolean getShowMobs() {
        return this.showMobs && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowHostile() {
        return this.showHostile && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowItems() {
        return this.showItems && !this.minimapDisplayItemsDisabled();
    }

    public boolean getShowOther() {
        return this.showOther && !this.minimapDisplayOtherDisabled();
    }

    public boolean getCaveMaps() {
        return this.caveMaps && !this.caveMapsDisabled();
    }

    public boolean getShowOtherTeam() {
        return this.showOtherTeam && !this.showOtherTeamDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getDeathpoints() {
        return this.deathpoints && !this.deathpointsDisabled();
    }

    public boolean getOldDeathpoints() {
        return this.oldDeathpoints;
    }

    public void setSlimeChunksSeed(long seed) {
        serverSlimeSeeds.put(Minimap.getCurrentWorldID(), seed);
    }

    public long getSlimeChunksSeed() {
        IntegratedServer sp = Minecraft.func_71410_x().func_71401_C();
        if (sp == null) {
            Long saved = serverSlimeSeeds.get(Minimap.getCurrentWorldID());
            return saved != null ? saved : 0L;
        }
        long seed = sp.func_130014_f_().func_72905_C();
        if (sp.func_130014_f_().field_73011_w.func_177502_q() != 0) {
            return 0L;
        }
        return seed;
    }

    public boolean customSlimeSeedNeeded() {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiSlimeSeed) && Minecraft.func_71410_x().func_71401_C() == null && Minecraft.func_71410_x().field_71441_e != null;
    }

    public boolean getSlimeChunks() {
        return this.slimeChunks && (Minecraft.func_71410_x().func_71401_C() != null || this.getSlimeChunksSeed() != 0L);
    }

    public boolean getShowIngameWaypoints() {
        return this.showIngameWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getShowCoords() {
        return this.showCoords;
    }

    public boolean getLockNorth() {
        return this.lockNorth || Minimap.enlargedMap;
    }

    public boolean getAntiAliasing() {
        return !Minimap.triedFBO || this.antiAliasing && Minimap.usingFBO();
    }

    public int getMinimapSize() {
        int size;
        if (this.mapSize > -1) {
            return this.mapSize;
        }
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int n = size = height <= width ? height : width;
        if (size <= 480) {
            return 0;
        }
        if (size <= 720) {
            return 1;
        }
        if (size <= 1080) {
            return 2;
        }
        return 3;
    }

    public boolean getSmoothDots() {
        return !Minimap.triedFBO || this.smoothDots && Minimap.usingFBO();
    }

    public void saveWaypoints() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(XaeroMinimap.waypointsFile));
        if (!Minimap.waypointMap.isEmpty()) {
            Set<Map.Entry<String, WaypointWorld>> keyMap = Minimap.waypointMap.entrySet();
            for (Map.Entry<String, WaypointWorld> entry : keyMap) {
                String name;
                int i;
                String worldID = entry.getKey();
                WaypointWorld world = entry.getValue();
                Object[] keys = world.sets.keySet().toArray();
                if (keys.length > 1) {
                    writer.print("world:" + worldID + ":" + world.current);
                    for (i = 0; i < keys.length; ++i) {
                        name = (String)keys[i];
                        if (name.equals(world.current)) continue;
                        writer.print(":" + (String)keys[i]);
                    }
                    writer.println("");
                }
                for (i = 0; i < keys.length; ++i) {
                    name = (String)keys[i];
                    WaypointSet set = world.sets.get(name);
                    if (set == null) continue;
                    for (Waypoint w : set.list) {
                        writer.println("waypoint:" + worldID + ":" + w.name.replaceAll(":", "\u00a7\u00a7") + ":" + w.symbol.replaceAll(":", "\u00a7\u00a7") + ":" + w.x + ":" + w.y + ":" + w.z + ":" + w.color + ":" + w.disabled + ":" + w.type + ":" + name + ":" + w.rotation + ":" + w.yaw);
                    }
                }
            }
        }
        writer.close();
    }

    public boolean checkWaypointsLine(String[] args) {
        if (args[0].equalsIgnoreCase("world")) {
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            Minimap.addWorld(args[1]);
            WaypointWorld map = Minimap.waypointMap.get(args[1]);
            map.current = args[2];
            for (int i = 2; i < args.length; ++i) {
                if (map.sets.get(args[i]) != null) continue;
                map.sets.put(args[i], new WaypointSet(map));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("waypoint")) {
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            Minimap.addWorld(args[1]);
            String setName = "gui.xaero_default";
            if (args.length > 10) {
                setName = args[10];
            }
            WaypointWorld map = Minimap.waypointMap.get(args[1]);
            WaypointSet waypoints = map.sets.get(setName);
            if (waypoints == null) {
                waypoints = new WaypointSet(map);
                map.sets.put(setName, waypoints);
            }
            Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[2].replaceAll("\u00a7\u00a7", ":"), args[3].replaceAll("\u00a7\u00a7", ":"), Integer.parseInt(args[7]));
            if (args.length > 8) {
                loadWaypoint.disabled = args[8].equals("true");
            }
            if (args.length > 9) {
                loadWaypoint.type = Integer.parseInt(args[9]);
            }
            if (args.length > 11) {
                loadWaypoint.rotation = args[11].equals("true");
            }
            if (args.length > 12) {
                loadWaypoint.yaw = Integer.parseInt(args[12]);
            }
            waypoints.list.add(loadWaypoint);
            return true;
        }
        return false;
    }

    public boolean loadWaypoints(File file) throws IOException {
        String s;
        if (!file.exists()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                this.checkWaypointsLine(args);
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
        return true;
    }

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(XaeroMinimap.optionsFile));
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("updateNotification:" + updateNotification);
        writer.println("settingsButton:" + settingsButton);
        writer.println("minimap:" + this.minimap);
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("showPlayers:" + this.showPlayers);
        writer.println("showHostile:" + this.showHostile);
        writer.println("showMobs:" + this.showMobs);
        writer.println("showItems:" + this.showItems);
        writer.println("showOther:" + this.showOther);
        writer.println("showOtherTeam:" + this.showOtherTeam);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("showIngameWaypoints:" + this.showIngameWaypoints);
        writer.println("displayRedstone:" + this.displayRedstone);
        writer.println("deathpoints:" + this.deathpoints);
        writer.println("oldDeathpoints:" + this.oldDeathpoints);
        writer.println("distance:" + this.distance);
        writer.println("showCoords:" + this.showCoords);
        writer.println("lockNorth:" + this.lockNorth);
        writer.println("zoom:" + this.zoom);
        writer.println("mapSize:" + this.mapSize);
        writer.println("entityAmount:" + this.entityAmount);
        writer.println("chunkGrid:" + this.chunkGrid);
        writer.println("slimeChunks:" + this.slimeChunks);
        writer.println("playersColor:" + this.playersColor);
        writer.println("mobsColor:" + this.mobsColor);
        writer.println("hostileColor:" + this.hostileColor);
        writer.println("itemsColor:" + this.itemsColor);
        writer.println("otherColor:" + this.otherColor);
        writer.println("otherTeamColor:" + this.otherTeamColor);
        writer.println("mapSafeMode:" + this.mapSafeMode);
        writer.println("minimapOpacity:" + this.minimapOpacity);
        writer.println("waypointsScale:" + this.waypointsScale);
        writer.println("antiAliasing:" + this.antiAliasing);
        writer.println("blockColours:" + this.blockColours);
        writer.println("lighting:" + this.lighting);
        writer.println("dotsScale:" + this.waypointsScale);
        writer.println("compassOverWaypoints:" + this.compassOverWaypoints);
        writer.println("showBiome:" + this.showBiome);
        writer.println("showEntityHeight:" + this.showEntityHeight);
        writer.println("showFlowers:" + this.showFlowers);
        writer.println("keepWaypointNames:" + this.keepWaypointNames);
        writer.println("waypointsDistance:" + this.waypointsDistance);
        writer.println("waypointsDistanceMin:" + this.waypointsDistanceMin);
        writer.println("waypointTp:" + this.waypointTp);
        writer.println("arrowScale:" + this.arrowScale);
        writer.println("arrowColour:" + this.arrowColour);
        writer.println("smoothDots:" + this.smoothDots);
        Object[] keys = serverSlimeSeeds.keySet().toArray();
        Object[] values = serverSlimeSeeds.values().toArray();
        for (int i = 0; i < keys.length; ++i) {
            writer.println("seed:" + keys[i] + ":" + values[i]);
        }
        for (Interface l : InterfaceHandler.list) {
            writer.println("interface:" + l.iname + ":" + l.actualx + ":" + l.actualy + ":" + l.centered + ":" + l.flipped + ":" + l.fromRight);
        }
        writer.println("#WAYPOINTS HAVE BEEN MOVED TO xaerowaypoints.txt!");
        for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
            KeyBinding kb = ControlsHandler.toAdd[i];
            writer.println("key_" + kb.func_151464_g() + ":" + kb.func_151463_i());
        }
        writer.close();
        this.saveWaypoints();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!XaeroMinimap.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        Minimap.waypointMap.clear();
        BufferedReader reader = new BufferedReader(new FileReader(XaeroMinimap.optionsFile));
        boolean saveWaypoints = false;
        block2: while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("ignoreUpdate")) {
                    ignoreUpdate = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("updateNotification")) {
                    updateNotification = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("settingsButton")) {
                    settingsButton = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("minimap")) {
                    this.minimap = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("caveMaps")) {
                    this.caveMaps = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showPlayers")) {
                    this.showPlayers = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showHostile")) {
                    this.showHostile = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showMobs")) {
                    this.showMobs = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showItems")) {
                    this.showItems = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showOther")) {
                    this.showOther = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showOtherTeam")) {
                    this.showOtherTeam = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showWaypoints")) {
                    this.showWaypoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("deathpoints")) {
                    this.deathpoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("oldDeathpoints")) {
                    this.oldDeathpoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showIngameWaypoints")) {
                    this.showIngameWaypoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("displayRedstone")) {
                    this.displayRedstone = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("distance")) {
                    this.distance = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("showCoords")) {
                    this.showCoords = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("lockNorth")) {
                    this.lockNorth = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("zoom")) {
                    this.zoom = Integer.parseInt(args[1]);
                    if (this.zoom < this.zooms.length) continue;
                    this.zoom = this.zooms.length - 1;
                    continue;
                }
                if (args[0].equalsIgnoreCase("mapSize")) {
                    this.mapSize = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("entityAmount")) {
                    this.entityAmount = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("chunkGrid")) {
                    this.chunkGrid = args[1].equals("true") ? 4 : (args[1].equals("false") ? -5 : Integer.parseInt(args[1]));
                    continue;
                }
                if (args[0].equalsIgnoreCase("slimeChunks")) {
                    this.slimeChunks = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("playersColor")) {
                    this.playersColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("mobsColor")) {
                    this.mobsColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("hostileColor")) {
                    this.hostileColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("itemsColor")) {
                    this.itemsColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("otherColor")) {
                    this.otherColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("otherTeamColor")) {
                    this.otherTeamColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("mapSafeMode")) {
                    this.mapSafeMode = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("minimapOpacity")) {
                    this.minimapOpacity = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypointsScale")) {
                    this.waypointsScale = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("antiAliasing")) {
                    this.antiAliasing = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("blockColours")) {
                    this.blockColours = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("lighting")) {
                    this.lighting = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("dotsScale")) {
                    this.dotsScale = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("compassOverWaypoints")) {
                    this.compassOverWaypoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showBiome")) {
                    this.showBiome = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showEntityHeight")) {
                    this.showEntityHeight = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showFlowers")) {
                    this.showFlowers = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("keepWaypointNames")) {
                    this.keepWaypointNames = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypointsDistance")) {
                    this.waypointsDistance = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypointsDistanceMin")) {
                    this.waypointsDistanceMin = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypointTp")) {
                    this.waypointTp = args[1];
                    continue;
                }
                if (args[0].equalsIgnoreCase("arrowScale")) {
                    this.arrowScale = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("arrowColour")) {
                    this.arrowColour = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("seed")) {
                    serverSlimeSeeds.put(args[1], Long.parseLong(args[2]));
                    continue;
                }
                if (args[0].equalsIgnoreCase("smoothDots")) {
                    this.smoothDots = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("interface")) {
                    for (Interface l : InterfaceHandler.list) {
                        if (!args[1].equals(l.iname)) continue;
                        l.actualx = l.x = Integer.parseInt(args[2]);
                        l.bx = l.x;
                        l.actualy = l.y = Integer.parseInt(args[3]);
                        l.by = l.y;
                        l.bcentered = l.centered = args[4].equals("true");
                        l.bflipped = l.flipped = args[5].equals("true");
                        l.bfromRight = l.fromRight = args[6].equals("true");
                    }
                    continue;
                }
                if (args[0].startsWith("key_")) {
                    for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
                        KeyBinding kb = ControlsHandler.toAdd[i];
                        if (!kb.func_151464_g().equals(args[0].substring(4))) continue;
                        kb.func_151462_b(Integer.parseInt(args[1]));
                        continue block2;
                    }
                    continue;
                }
                if (!this.checkWaypointsLine(args)) continue;
                saveWaypoints = true;
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
        this.loadWaypoints(XaeroMinimap.waypointsFile);
        if (saveWaypoints) {
            this.saveWaypoints();
            this.saveSettings();
        }
        KeyBinding.func_74508_b();
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions == ModOptions.DOTS_SCALE && !Minimap.usingFBO()) {
            return s + "\u00a7e" + ModSettings.getTranslation(false);
        }
        if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE) {
            s = this.waypointsDistance == 0.0f ? s + I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : s + (int)this.waypointsDistance + "m";
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            s = this.waypointsDistanceMin == 0.0f ? s + I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : s + (int)this.waypointsDistanceMin + "m";
        } else {
            if (par1EnumOptions.getEnumFloat()) {
                String f1 = "" + this.getOptionFloatValue(par1EnumOptions);
                if (par1EnumOptions == ModOptions.ARROW_SCALE) {
                    f1 = f1 + "x";
                }
                return s + f1;
            }
            if (par1EnumOptions == ModOptions.CHUNK_GRID) {
                s = s + (this.chunkGrid > -1 ? format + ENCHANT_COLORS[this.chunkGrid] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.chunkGrid], (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]));
            } else if (par1EnumOptions == ModOptions.EDIT) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.DOTS) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.RESET) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.WAYPOINTS_TP) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.ZOOM) {
                s = s + this.zooms[this.zoom] + "x";
            } else if (par1EnumOptions == ModOptions.COLOURS) {
                s = s + I18n.func_135052_a((String)blockColourTypes[this.blockColours], (Object[])new Object[0]) + (SupportMods.usingWorldMapChunks() && this.blockColours != 0 ? "\u00a7e (" + I18n.func_135052_a((String)"N/A", (Object[])new Object[0]) + ")" : "");
            } else if (par1EnumOptions == ModOptions.DISTANCE) {
                s = s + I18n.func_135052_a((String)distanceTypes[this.distance], (Object[])new Object[0]);
            } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded()) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.SIZE) {
                s = s + I18n.func_135052_a((String)(this.mapSize > -1 ? MINIMAP_SIZE[this.mapSize] : "gui.xaero_auto_map_size"), (Object[])new Object[0]);
            } else if (par1EnumOptions == ModOptions.EAMOUNT) {
                s = this.entityAmount == 0 ? s + I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : s + 100 * this.entityAmount;
            } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
                s = s + I18n.func_135052_a((String)this.arrowColourNames[this.arrowColour], (Object[])new Object[0]);
            } else {
                boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
                boolean serverSetting = this.getBooleanValue(par1EnumOptions);
                s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
            }
        }
        return s;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps();
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.getShowOtherTeam();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.getDeathpoints();
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.getOldDeathpoints();
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.getShowIngameWaypoints();
        }
        if (o == ModOptions.COORDS) {
            return this.getShowCoords();
        }
        if (o == ModOptions.NORTH) {
            return this.getLockNorth();
        }
        if (o == ModOptions.PLAYERS) {
            return this.getShowPlayers();
        }
        if (o == ModOptions.HOSTILE) {
            return this.getShowHostile();
        }
        if (o == ModOptions.MOBS) {
            return this.getShowMobs();
        }
        if (o == ModOptions.ITEMS) {
            return this.getShowItems();
        }
        if (o == ModOptions.ENTITIES) {
            return this.getShowOther();
        }
        if (o == ModOptions.SAFE_MAP) {
            return Minimap.triedFBO && !Minimap.usingFBO();
        }
        if (o == ModOptions.AA) {
            return this.getAntiAliasing();
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.getSmoothDots();
        }
        return this.getClientBooleanValue(o);
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.minimap;
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.caveMaps;
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.showOtherTeam;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.deathpoints;
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.oldDeathpoints;
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.showIngameWaypoints;
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.COORDS) {
            return this.showCoords;
        }
        if (o == ModOptions.NORTH) {
            return this.lockNorth;
        }
        if (o == ModOptions.PLAYERS) {
            return this.showPlayers;
        }
        if (o == ModOptions.HOSTILE) {
            return this.showHostile;
        }
        if (o == ModOptions.MOBS) {
            return this.showMobs;
        }
        if (o == ModOptions.ITEMS) {
            return this.showItems;
        }
        if (o == ModOptions.ENTITIES) {
            return this.showOther;
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode;
        }
        if (o == ModOptions.AA) {
            return this.antiAliasing;
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.COMPASS) {
            return this.compassOverWaypoints;
        }
        if (o == ModOptions.BIOME) {
            return this.showBiome;
        }
        if (o == ModOptions.ENTITY_HEIGHT) {
            return this.showEntityHeight;
        }
        if (o == ModOptions.FLOWERS) {
            return this.showFlowers;
        }
        if (o == ModOptions.KEEP_WP_NAMES) {
            return this.keepWaypointNames;
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.smoothDots;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.zoom = (this.zoom + 1) % this.zooms.length;
        } else if (par1EnumOptions == ModOptions.SIZE) {
            this.mapSize = this.mapSize == 3 ? -1 : (this.mapSize + 1) % 4;
        } else if (par1EnumOptions == ModOptions.EAMOUNT) {
            this.entityAmount = (this.entityAmount + 1) % 11;
        } else if (par1EnumOptions == ModOptions.MINIMAP) {
            this.minimap = !this.minimap;
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            this.caveMaps = !this.caveMaps;
        } else if (par1EnumOptions == ModOptions.DISPLAY_OTHER_TEAM) {
            this.showOtherTeam = !this.showOtherTeam;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.showWaypoints = !this.showWaypoints;
        } else if (par1EnumOptions == ModOptions.DEATHPOINTS) {
            this.deathpoints = !this.deathpoints;
        } else if (par1EnumOptions == ModOptions.OLD_DEATHPOINTS) {
            this.oldDeathpoints = !this.oldDeathpoints;
        } else if (par1EnumOptions == ModOptions.INGAME_WAYPOINTS) {
            this.showIngameWaypoints = !this.showIngameWaypoints;
        } else if (par1EnumOptions == ModOptions.REDSTONE) {
            this.displayRedstone = !this.displayRedstone;
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            this.distance = (this.distance + 1) % distanceTypes.length;
        } else if (par1EnumOptions == ModOptions.COORDS) {
            this.showCoords = !this.showCoords;
        } else if (par1EnumOptions == ModOptions.NORTH) {
            this.lockNorth = !this.lockNorth;
        } else if (par1EnumOptions == ModOptions.PLAYERS) {
            this.showPlayers = !this.showPlayers;
        } else if (par1EnumOptions == ModOptions.HOSTILE) {
            this.showHostile = !this.showHostile;
        } else if (par1EnumOptions == ModOptions.MOBS) {
            this.showMobs = !this.showMobs;
        } else if (par1EnumOptions == ModOptions.ITEMS) {
            this.showItems = !this.showItems;
        } else if (par1EnumOptions == ModOptions.ENTITIES) {
            this.showOther = !this.showOther;
        } else if (par1EnumOptions == ModOptions.CHUNK_GRID) {
            if (this.chunkGrid == COLORS.length - 1) {
                this.chunkGrid = -4;
            } else {
                if (this.chunkGrid < -1) {
                    this.chunkGrid = -1;
                }
                ++this.chunkGrid;
            }
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS) {
            if (this.customSlimeSeedNeeded()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(Minecraft.func_71410_x().field_71462_r));
                return;
            }
            this.slimeChunks = !this.slimeChunks;
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.SAFE_MAP) {
            this.mapSafeMode = !this.mapSafeMode;
            Minimap.resetImage();
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.AA) {
            this.antiAliasing = !this.antiAliasing;
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            this.blockColours = (this.blockColours + 1) % blockColourTypes.length;
        } else if (par1EnumOptions == ModOptions.LIGHT) {
            this.lighting = !this.lighting;
        } else if (par1EnumOptions == ModOptions.COMPASS) {
            this.compassOverWaypoints = !this.compassOverWaypoints;
        } else if (par1EnumOptions == ModOptions.BIOME) {
            this.showBiome = !this.showBiome;
        } else if (par1EnumOptions == ModOptions.ENTITY_HEIGHT) {
            this.showEntityHeight = !this.showEntityHeight;
        } else if (par1EnumOptions == ModOptions.FLOWERS) {
            this.showFlowers = !this.showFlowers;
        } else if (par1EnumOptions == ModOptions.KEEP_WP_NAMES) {
            this.keepWaypointNames = !this.keepWaypointNames;
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            this.arrowColour = (this.arrowColour + 1) % this.arrowColours.length;
        } else if (par1EnumOptions == ModOptions.SMOOTH_DOTS) {
            this.smoothDots = !this.smoothDots;
        }
        this.saveSettings();
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    public void setOptionFloatValue(ModOptions options, float f) throws IOException {
        if (options == ModOptions.OPACITY) {
            this.minimapOpacity = f;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            this.waypointsScale = f;
        }
        if (options == ModOptions.DOTS_SCALE) {
            this.dotsScale = f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            this.waypointsDistance = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            this.waypointsDistanceMin = (int)f;
        }
        if (options == ModOptions.ARROW_SCALE) {
            this.arrowScale = f;
        }
        this.saveSettings();
    }

    public float getOptionFloatValue(ModOptions options) {
        if (options == ModOptions.OPACITY) {
            return this.minimapOpacity;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            return this.waypointsScale;
        }
        if (options == ModOptions.DOTS_SCALE) {
            return this.dotsScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            return this.waypointsDistance;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            return this.waypointsDistanceMin;
        }
        if (options == ModOptions.ARROW_SCALE) {
            return this.arrowScale;
        }
        return 1.0f;
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) != 1;
    }

    public boolean minimapDisplayPlayersDisabled() {
        return (serverSettings & 0x400) != 1024;
    }

    public boolean minimapDisplayMobsDisabled() {
        return (serverSettings & 0x800) != 2048;
    }

    public boolean minimapDisplayItemsDisabled() {
        return (serverSettings & 0x1000) != 4096;
    }

    public boolean minimapDisplayOtherDisabled() {
        return (serverSettings & 0x2000) != 8192;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) != 16384;
    }

    public boolean showOtherTeamDisabled() {
        return (serverSettings & 0x8000) != 32768;
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) != 65536;
    }

    public boolean deathpointsDisabled() {
        return (serverSettings & 0x200000) == 0;
    }

    public void resetServerSettings() {
        serverSettings = Integer.MAX_VALUE;
    }

    public static void setServerSettings() {
    }

    static {
        keysLoaded = false;
        ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        ENCHANT_COLOR_NAMES = new String[]{"gui.xaero_black", "gui.xaero_dark_blue", "gui.xaero_dark_green", "gui.xaero_dark_aqua", "gui.xaero_dark_red", "gui.xaero_dark_purple", "gui.xaero_gold", "gui.xaero_gray", "gui.xaero_dark_gray", "gui.xaero_blue", "gui.xaero_green", "gui.xaero_aqua", "gui.xaero_red", "gui.xaero_purple", "gui.xaero_yellow", "gui.xaero_white"};
        COLORS = new int[]{new Color(0, 0, 0, 255).hashCode(), new Color(0, 0, 170, 255).hashCode(), new Color(0, 170, 0, 255).hashCode(), new Color(0, 170, 170, 255).hashCode(), new Color(170, 0, 0, 255).hashCode(), new Color(170, 0, 170, 255).hashCode(), new Color(255, 170, 0, 255).hashCode(), new Color(170, 170, 170, 255).hashCode(), new Color(85, 85, 85, 255).hashCode(), new Color(85, 85, 255, 255).hashCode(), new Color(85, 255, 85, 255).hashCode(), new Color(85, 255, 255, 255).hashCode(), new Color(255, 0, 0, 255).hashCode(), new Color(255, 85, 255, 255).hashCode(), new Color(255, 255, 85, 255).hashCode(), new Color(255, 255, 255, 255).hashCode()};
        MINIMAP_SIZE = new String[]{"gui.xaero_tiny", "gui.xaero_small", "gui.xaero_medium", "gui.xaero_large"};
        serverSettings = Integer.MAX_VALUE;
        keyBindSettings = new KeyBinding("gui.xaero_minimap_settings", 21, "Xaero's Minimap");
        keyBindZoom = new KeyBinding("gui.xaero_zoom_in", 23, "Xaero's Minimap");
        keyBindZoom1 = new KeyBinding("gui.xaero_zoom_out", 24, "Xaero's Minimap");
        newWaypoint = new KeyBinding("gui.xaero_new_waypoint", 48, "Xaero's Minimap");
        keyWaypoints = new KeyBinding("gui.xaero_waypoints_key", 22, "Xaero's Minimap");
        keyLargeMap = new KeyBinding("gui.xaero_enlarge_map", 44, "Xaero's Minimap");
        keyToggleMap = new KeyBinding("gui.xaero_toggle_map", 35, "Xaero's Minimap");
        keyToggleWaypoints = new KeyBinding("gui.xaero_toggle_waypoints", 40, "Xaero's Minimap");
        keyToggleSlimes = new KeyBinding("gui.xaero_toggle_slime", 0, "Xaero's Minimap");
        keyToggleGrid = new KeyBinding("gui.xaero_toggle_grid", 0, "Xaero's Minimap");
        keyInstantWaypoint = new KeyBinding("gui.xaero_instant_waypoint", 78, "Xaero's Minimap");
        serverSlimeSeeds = new HashMap();
        distanceTypes = new String[]{"gui.xaero_off", "gui.xaero_looking_at", "gui.xaero_all"};
        blockColourTypes = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
        settingsButton = true;
        updateNotification = true;
    }
}

