/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.interfaces;

import com.minimap.XaeroMinimap;
import com.minimap.gui.GuiEditMode;
import com.minimap.gui.GuiMinimap;
import com.minimap.interfaces.Interface;
import com.minimap.interfaces.Preset;
import com.minimap.minimap.Minimap;
import com.minimap.minimap.Waypoint;
import com.minimap.settings.ModOptions;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.WorldChunkManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class InterfaceHandler {
    public static int actionTimer = 0;
    public static ArrayList<Preset> presets = new ArrayList();
    public static ArrayList<Interface> list = new ArrayList();
    public static final ResourceLocation invtextures = new ResourceLocation("textures/gui/container/inventory.png");
    public static Minecraft mc = XaeroMinimap.mc;
    public static int selectedId = -1;
    public static int draggingId = -1;
    public static int draggingOffX = 0;
    public static int draggingOffY = 0;
    public static Minimap minimap;
    public static final ResourceLocation guiTextures;
    public static final ResourceLocation mapTextures;
    public static long lastFlip;
    public static final Color disabled;
    public static final Color enabled;
    public static final Color selected;

    public static void loadPresets() {
        new Preset("gui.xaero_preset_topleft", new int[][]{{0, 0}, {0, 10000}, {0, 0}, {0, 36}, {0, 0}}, new boolean[][]{{true, false}, {true, false}, {false, true}, {true, false}, {false, false}});
        new Preset("gui.xaero_preset_topright", new int[][]{{0, 0}, {0, 135}, {120, 0}, {0, 50}, {0, 0}}, new boolean[][]{{false, true}, {false, false}, {true, false}, {true, false}, {false, true}});
        new Preset("gui.xaero_preset_bottom_left", new int[][]{{0, 0}, {0, 135}, {120, 0}, {0, 50}, {0, 10000}}, new boolean[][]{{false, true}, {false, false}, {true, false}, {true, false}, {false, false}});
        new Preset("gui.xaero_preset_bottom_right", new int[][]{{0, 0}, {0, 135}, {120, 0}, {0, 50}, {0, 10000}}, new boolean[][]{{false, true}, {false, false}, {true, false}, {true, false}, {false, true}});
    }

    public static void load() {
        new Interface("", 0, 0, ModOptions.DEFAULT){};
        new Interface("", 0, 0, ModOptions.DEFAULT){};
        new Interface("", 0, 0, ModOptions.DEFAULT){};
        new Interface("", 0, 0, ModOptions.DEFAULT){};
        minimap = new Minimap(new Interface("gui.xaero_minimap", 128, 128, ModOptions.MINIMAP){
            long lastFBOTry = 0L;
            int lastMinimapSize = 0;
            private ArrayList<String> underText = new ArrayList();

            @Override
            public int getW(int scale) {
                return this.getSize() / scale;
            }

            @Override
            public int getH(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getWC(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getHC(int scale) {
                return this.getH(scale);
            }

            @Override
            public int getW0(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getH0(int scale) {
                return this.getH(scale);
            }

            @Override
            public int getSize() {
                return minimap.getMinimapWidth() + 36 + 2;
            }

            public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy) {
                double X;
                double Y = (pc * offx + ps * offy) * Minimap.zoom;
                double borderedX = X = (ps * offx - pc * offy) * Minimap.zoom;
                double borderedY = Y;
                if (borderedX > (double)specW) {
                    borderedX = specW;
                    borderedY = Y * (double)specW / X;
                } else if (borderedX < (double)(-specW)) {
                    borderedX = -specW;
                    borderedY = -Y * (double)specW / X;
                }
                if (borderedY > (double)specH) {
                    borderedY = specH;
                    borderedX = X * (double)specH / Y;
                } else if (borderedY < (double)(-specH)) {
                    borderedY = -specH;
                    borderedX = -X * (double)specH / Y;
                }
                GL11.glPushMatrix();
                GlStateManager.func_179137_b((double)borderedX, (double)borderedY, (double)0.0);
            }

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                int specW;
                int mapW;
                if (Minimap.loadedFBO && !OpenGlHelper.func_148822_b()) {
                    Minimap.loadedFBO = false;
                    Minimap.scalingFrameBuffer.func_147608_a();
                    Minimap.rotationFrameBuffer.func_147608_a();
                    Minimap.resetImage();
                }
                if (!Minimap.loadedFBO && !XaeroMinimap.getSettings().mapSafeMode && System.currentTimeMillis() - this.lastFBOTry > 1000L) {
                    this.lastFBOTry = System.currentTimeMillis();
                    Minimap.loadFrameBuffer();
                }
                if (XaeroMinimap.getSettings().getMinimapSize() != this.lastMinimapSize) {
                    this.lastMinimapSize = XaeroMinimap.getSettings().getMinimapSize();
                    Minimap.resetImage();
                    Minimap.frameUpdateNeeded = Minimap.usingFBO();
                }
                long before = System.currentTimeMillis();
                int bufferSize = Minimap.usingFBO() ? minimap.getFBOBufferSize() : minimap.getBufferSize();
                float mapScale = (float)scale / 2.0f;
                int mapH = InterfaceHandler.minimap.minimapHeight = (mapW = (InterfaceHandler.minimap.minimapWidth = minimap.getMinimapWidth()));
                Minimap.frameUpdatePartialTicks = partial;
                minimap.updateZoom();
                Minimap.zoom = minimap.getZoom();
                RenderHelper.func_74518_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float sizeFix = (float)bufferSize / 512.0f;
                if (Minimap.usingFBO()) {
                    minimap.renderFrameToFBO(bufferSize, mapW, sizeFix, partial, true);
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                    Minimap.rotationFrameBuffer.func_147612_c();
                    sizeFix = 1.0f;
                } else {
                    minimap.updateMapFrame(bufferSize, partial);
                    GL11.glScalef((float)sizeFix, (float)sizeFix, (float)1.0f);
                    Minimap.bindTextureBuffer(Minimap.mapTexture.getBuffer(bufferSize), bufferSize, bufferSize, Minimap.mapTexture.func_110552_b());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(XaeroMinimap.getSettings().minimapOpacity / 100.0f));
                }
                GL11.glEnable((int)3008);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
                int scaledX = (int)((float)this.x * mapScale);
                int scaledY = (int)((float)this.y * mapScale);
                InterfaceHandler.mc.field_71456_v.func_73729_b((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 0, (int)((float)(mapW / 2 + 1) / sizeFix), (int)((float)(mapH / 2 + 1) / sizeFix));
                if (!Minimap.usingFBO()) {
                    GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                int specH = specW = mapW / 2 + 6;
                double angle = Math.toRadians(Minimap.getRenderAngle());
                double ps = Math.sin(Math.PI - angle);
                double pc = Math.cos(Math.PI - angle);
                mc.func_110434_K().func_110577_a(guiTextures);
                if (XaeroMinimap.getSettings().getLockNorth()) {
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    double arrowX = (double)(2 * scaledX + 18 + (mapW + 1) / 2) + 0.5;
                    double arrowY = (double)(2 * scaledY + 18 + (mapH + 1) / 2) + 0.5;
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    this.drawArrow(arrowX, arrowY + 1.0, new float[]{0.0f, 0.0f, 0.0f, 0.5f});
                    this.drawArrow(arrowX, arrowY, XaeroMinimap.getSettings().arrowColours[XaeroMinimap.getSettings().arrowColour]);
                    GL11.glPopMatrix();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                }
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4, 0, 15, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + mapH / 2 - 6, 0, 30, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4 + mapH / 2 - 6, 0, 45, 17, 15);
                int horLineLength = (mapW / 2 - 16) / 16;
                for (int i = 0; i < horLineLength; ++i) {
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4, 0, 60, 16, 4);
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4 + mapH / 2 + 9 - 4, 0, 64, 16, 4);
                }
                int vertLineLength = (mapH / 2 - 14) / 5;
                for (int i = 0; i < vertLineLength; ++i) {
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 68, 4, 5);
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 73, 4, 5);
                }
                GL11.glPushMatrix();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                GlStateManager.func_179109_b((float)(2 * scaledX + specW - 6 + 18), (float)(2 * scaledY + specH - 6 + 18), (float)0.0f);
                if (XaeroMinimap.getSettings().compassOverWaypoints) {
                    this.drawWaypoints(specW, specH, ps, pc, partial);
                    this.drawCompass(specW, specH, ps, pc);
                } else {
                    this.drawCompass(specW, specH, ps, pc);
                    this.drawWaypoints(specW, specH, ps, pc, partial);
                }
                GL11.glPopMatrix();
                if (XaeroMinimap.getSettings().getShowCoords()) {
                    int interfaceSize = this.getSize() / 2;
                    String coords = Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70165_t) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70163_u) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70161_v);
                    if (InterfaceHandler.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                        String stringLevel = "" + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70163_u);
                        coords = Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70165_t) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70161_v);
                        this.underText.add(coords);
                        this.underText.add(stringLevel);
                    } else {
                        this.underText.add(coords);
                    }
                }
                if (XaeroMinimap.getSettings().showBiome) {
                    BlockPos pos = new BlockPos(InterfaceHandler.mc.func_175606_aa().field_70165_t, InterfaceHandler.mc.func_175606_aa().func_174813_aQ().field_72338_b, InterfaceHandler.mc.func_175606_aa().field_70161_v);
                    this.underText.add(InterfaceHandler.mc.field_71441_e.func_175726_f((BlockPos)pos).func_177411_a((BlockPos)pos, (WorldChunkManager)InterfaceHandler.mc.field_71441_e.func_72959_q()).field_76791_y);
                }
                this.drawTextUnderMinimap(scaledX, scaledY, height, mapScale);
                GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }

            private void drawArrow(double arrowX, double arrowY, float[] colour) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
                GlStateManager.func_179114_b((float)InterfaceHandler.mc.field_71439_g.field_70177_z, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)(0.5f * XaeroMinimap.getSettings().arrowScale), (float)(0.5f * XaeroMinimap.getSettings().arrowScale), (float)1.0f);
                GL11.glTranslated((double)-13.0, (double)-6.0, (double)0.0);
                GL11.glColor4f((float)colour[0], (float)colour[1], (float)colour[2], (float)colour[3]);
                InterfaceHandler.mc.field_71456_v.func_73729_b(0, 0, 49, 0, 26, 27);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }

            public void drawTextUnderMinimap(int scaledX, int scaledY, int height, float mapScale) {
                int interfaceSize = this.getSize() / 2;
                int scaledHeight = (int)((float)height * mapScale);
                for (int i = 0; i < this.underText.size(); ++i) {
                    String s = this.underText.get(i);
                    int stringWidth = InterfaceHandler.mc.field_71466_p.func_78256_a(s);
                    boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
                    int stringY = scaledY + (under ? interfaceSize : -9) + i * 9 * (under ? 1 : -1);
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(scaledX + interfaceSize / 2 - stringWidth / 2), (float)stringY, Minimap.radarPlayers.hashCode());
                }
                this.underText.clear();
            }

            private void drawWaypoints(int specW, int specH, double ps, double pc, float partial) {
                if (XaeroMinimap.settings.getShowWaypoints() && Minimap.waypoints != null) {
                    double playerX = Minimap.getEntityX((Entity)InterfaceHandler.mc.field_71439_g, partial);
                    double playerZ = Minimap.getEntityZ((Entity)InterfaceHandler.mc.field_71439_g, partial);
                    this.renderWaypointsList(Minimap.waypoints.list, playerX, playerZ, specW, specH, ps, pc);
                }
            }

            private void renderWaypointsList(ArrayList<Waypoint> waypoints, double playerX, double playerZ, int specW, int specH, double ps, double pc) {
                for (Waypoint w : waypoints) {
                    if (w == null || w.disabled || w.type == 1 && !XaeroMinimap.getSettings().getDeathpoints() || XaeroMinimap.getSettings().waypointsDistance != 0.0f && w.lastDistance > (double)XaeroMinimap.getSettings().waypointsDistance) continue;
                    double offx = (double)w.x - playerX;
                    double offy = (double)w.z - playerZ;
                    this.translatePosition(specW, specH, ps, pc, offx, offy);
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                    w.drawIconOnGUI(-4, -4);
                    GL11.glPopMatrix();
                }
            }

            private void drawCompass(int specW, int specH, double ps, double pc) {
                String[] nesw = new String[]{"N", "E", "S", "W"};
                for (int i = 0; i < 4; ++i) {
                    double offx;
                    double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
                    double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
                    this.translatePosition(specW, specH, ps, pc, offx, offy);
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(nesw[i], (float)(1 - InterfaceHandler.mc.field_71466_p.func_78256_a(nesw[i]) / 2), -3.0f, Minimap.radarPlayers.hashCode());
                    GL11.glPopMatrix();
                }
            }
        });
    }

    public static void drawInterfaces(float partial) {
        ScaledResolution scaledresolution = new ScaledResolution(XaeroMinimap.mc);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        int scale = scaledresolution.func_78325_e();
        int mouseX = Mouse.getX() * width / XaeroMinimap.mc.field_71443_c;
        int mouseY = height - Mouse.getY() * height / XaeroMinimap.mc.field_71440_d - 1;
        InterfaceHandler.updateInterfaces(mouseX, mouseY, width, height, scale);
        for (Interface l : list) {
            if (!XaeroMinimap.settings.getBooleanValue(l.option)) continue;
            l.drawInterface(width, height, scale, partial);
        }
    }

    public static boolean overAButton(int mouseX, int mouseY) {
        if (InterfaceHandler.mc.field_71462_r instanceof GuiEditMode) {
            for (int k = 0; k < ((GuiEditMode)InterfaceHandler.mc.field_71462_r).getButtons().size(); ++k) {
                GuiButton b = (GuiButton)((GuiEditMode)InterfaceHandler.mc.field_71462_r).getButtons().get(k);
                if (mouseX < b.field_146128_h || mouseY < b.field_146129_i || mouseX >= b.field_146128_h + 150 || mouseY >= b.field_146129_i + 20) continue;
                return true;
            }
        }
        return false;
    }

    public static void confirm() {
        for (Interface l : list) {
            l.bx = l.actualx;
            l.by = l.actualy;
            l.bcentered = l.centered;
            l.bflipped = l.flipped;
            l.bfromRight = l.fromRight;
        }
    }

    public static void cancel() {
        for (Interface l : list) {
            l.actualx = l.bx;
            l.actualy = l.by;
            l.centered = l.bcentered;
            l.flipped = l.bflipped;
            l.fromRight = l.bfromRight;
        }
    }

    public static void applyPreset(int id) {
        for (Interface l : list) {
            actionTimer = 10;
            l.actualx = InterfaceHandler.presets.get((int)id).coords[l.id][0];
            l.actualy = InterfaceHandler.presets.get((int)id).coords[l.id][1];
            l.centered = InterfaceHandler.presets.get((int)id).types[l.id][0];
            l.flipped = l.cflipped;
            l.fromRight = InterfaceHandler.presets.get((int)id).types[l.id][1];
        }
    }

    public static void updateInterfaces(int mouseX, int mouseY, int width, int height, int scale) {
        if (actionTimer <= 0) {
            if (XaeroMinimap.events.lastGuiOpen instanceof GuiEditMode) {
                int i;
                if (Mouse.isButtonDown((int)1)) {
                    selectedId = -1;
                }
                if ((i = InterfaceHandler.getInterfaceId(mouseX, mouseY, width, height, scale)) == -1) {
                    i = selectedId;
                }
                if (i != -1) {
                    if (Mouse.isButtonDown((int)0) && draggingId == -1) {
                        draggingId = i;
                        selectedId = i;
                        if (InterfaceHandler.list.get((int)i).fromRight) {
                            InterfaceHandler.list.get((int)i).x = width - InterfaceHandler.list.get((int)i).x;
                        }
                        draggingOffX = InterfaceHandler.list.get((int)i).x - mouseX;
                        draggingOffY = InterfaceHandler.list.get((int)i).y - mouseY;
                        if (InterfaceHandler.list.get((int)i).fromRight) {
                            InterfaceHandler.list.get((int)i).x = width - InterfaceHandler.list.get((int)i).x;
                        }
                    } else if (!Mouse.isButtonDown((int)0) && draggingId != -1) {
                        draggingId = -1;
                        draggingOffX = 0;
                        draggingOffY = 0;
                    }
                    if (selectedId != -1) {
                        i = selectedId;
                    }
                    if (Keyboard.isKeyDown((int)33) && System.currentTimeMillis() - lastFlip > 300L) {
                        lastFlip = System.currentTimeMillis();
                        boolean bl = InterfaceHandler.list.get((int)i).flipped = !InterfaceHandler.list.get((int)i).flipped;
                    }
                    if (Keyboard.isKeyDown((int)46) && System.currentTimeMillis() - lastFlip > 300L) {
                        lastFlip = System.currentTimeMillis();
                        boolean bl = InterfaceHandler.list.get((int)i).centered = !InterfaceHandler.list.get((int)i).centered;
                    }
                    if (Keyboard.isKeyDown((int)31)) {
                        selectedId = -1;
                        draggingId = -1;
                        switch (i) {
                            case 4: {
                                InterfaceHandler.mc.field_71462_r.field_146297_k.func_147108_a((GuiScreen)new GuiMinimap(InterfaceHandler.mc.field_71462_r, XaeroMinimap.getSettings()));
                            }
                        }
                    }
                }
                if (draggingId != -1) {
                    if (!InterfaceHandler.list.get((int)InterfaceHandler.draggingId).centered) {
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = mouseX + draggingOffX;
                        if (InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight) {
                            InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = width - InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx;
                        }
                    }
                    if (InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx > width / 2) {
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight = !InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight;
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = width - InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx;
                    }
                    InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualy = mouseY + draggingOffY;
                }
            }
        } else {
            --actionTimer;
        }
        for (Interface j : list) {
            j.x = j.actualx;
            j.y = j.actualy;
            if (j.fromRight) {
                j.x = width - j.x;
            }
            if (j.centered) {
                if (j.multi) {
                    j.w = j.getWC(scale);
                    j.h = j.getHC(scale);
                }
                j.x = width / 2 - j.getW(scale) / 2;
            } else if (j.multi) {
                j.w = j.getW0(scale);
                j.h = j.getH0(scale);
            }
            if (j.x < 5) {
                j.x = 0;
            }
            if (j.y < 5) {
                j.y = 0;
            }
            if (j.x + j.getW(scale) > width - 5) {
                j.x = width - j.getW(scale);
            }
            if (j.y + j.getH(scale) <= height - 5) continue;
            j.y = height - j.getH(scale);
        }
    }

    public static void drawBoxes(int mouseX, int mouseY, int width, int height, int scale) {
        if (XaeroMinimap.events.lastGuiOpen instanceof GuiEditMode) {
            int mouseOverId = InterfaceHandler.getInterfaceId(mouseX, mouseY, width, height, scale);
            for (int i = 0; i < list.size(); ++i) {
                if (!XaeroMinimap.settings.getBooleanValue(InterfaceHandler.list.get((int)i).option)) continue;
                int x = InterfaceHandler.list.get((int)i).x;
                if (InterfaceHandler.list.get((int)i).fromRight) {
                    x = width - x;
                }
                int y = InterfaceHandler.list.get((int)i).y;
                int w = list.get(i).getW(scale);
                int h = list.get(i).getH(scale);
                int x2 = x + w;
                int y2 = y + h;
                if (selectedId == i || !InterfaceHandler.overAButton(mouseX, mouseY) && mouseX >= x && mouseX <= x2 && mouseY >= y && mouseY <= y2 || i == draggingId) {
                    Gui.func_73734_a((int)x, (int)y, (int)x2, (int)y2, (int)(selectedId == i ? selected.hashCode() : enabled.hashCode()));
                    if (draggingId != -1 || i != mouseOverId) continue;
                    InterfaceHandler.list.get((int)i).cBox.drawBox(mouseX, mouseY, width, height);
                    continue;
                }
                Gui.func_73734_a((int)x, (int)y, (int)x2, (int)y2, (int)disabled.hashCode());
            }
        }
    }

    public static int getInterfaceId(int mouseX, int mouseY, int width, int height, int scale) {
        int toReturn = -1;
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            int x = InterfaceHandler.list.get((int)i).x;
            if (InterfaceHandler.list.get((int)i).fromRight) {
                x = width - x;
            }
            int y = InterfaceHandler.list.get((int)i).y;
            int x2 = x + list.get(i).getW(scale);
            int y2 = y + list.get(i).getH(scale);
            int isize = list.get(i).getSize();
            if (size != 0 && isize >= size || InterfaceHandler.overAButton(mouseX, mouseY) || mouseX < x || mouseX >= x2 || mouseY < y || mouseY >= y2) continue;
            size = isize;
            toReturn = i;
        }
        return toReturn;
    }

    static {
        guiTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
        mapTextures = new ResourceLocation("xaeromaptexture");
        lastFlip = 0L;
        disabled = new Color(189, 189, 189, 80);
        enabled = new Color(255, 255, 255, 100);
        selected = new Color(255, 255, 255, 130);
    }
}

