/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.util.StateHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCounter
extends BlockFurniture {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", CounterType.class);

    public BlockCounter(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149769_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.NORMAL)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof BlockCounter) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.CORNER_LEFT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.CORNER_RIGHT));
            }
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) instanceof BlockCounter) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) == StateHelper.Direction.LEFT && !(StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) instanceof BlockCounter)) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.INVERT_RIGHT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) == StateHelper.Direction.RIGHT && !(StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) instanceof BlockCounter)) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.INVERT_LEFT));
            }
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.NORMAL));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return FurnitureItems.itemCounterDoored;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return new ItemStack(FurnitureItems.itemCounterDoored);
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, TYPE});
    }

    public static enum CounterType implements IStringSerializable
    {
        NORMAL,
        CORNER_LEFT,
        CORNER_RIGHT,
        INVERT_LEFT,
        INVERT_RIGHT;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

