/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.api;

import com.mrcrayfish.furniture.api.IRecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeConditions;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.RecipeType;
import com.mrcrayfish.furniture.api.RecipeUtil;
import com.mrcrayfish.furniture.api.RecipeVariables;
import com.mrcrayfish.furniture.handler.ConfigurationHandler;
import java.util.Map;

public class RecipeRegistryComm
extends RecipeAPI
implements IRecipeRegistry {
    private static RecipeRegistryComm furnitureRegister = null;
    private String modName;

    public static RecipeRegistryComm getInstance(String modName) {
        if (furnitureRegister == null) {
            furnitureRegister = new RecipeRegistryComm();
        }
        RecipeRegistryComm.furnitureRegister.modName = modName;
        return furnitureRegister;
    }

    @Override
    public void registerRecipe(String type, RecipeVariables variables) {
        Map<String, Object> varMap = variables.getMap();
        if (type.equalsIgnoreCase("minebay")) {
            if (RecipeConditions.hasMineBayArgs(varMap)) {
                RecipeRegistryComm.addMineBayRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables", this.modName);
            }
        } else if (type.equalsIgnoreCase("oven")) {
            if (RecipeConditions.hasOvenArgs(varMap)) {
                RecipeRegistryComm.addOvenRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables", this.modName);
            }
        } else if (type.equalsIgnoreCase("freezer")) {
            if (RecipeConditions.hasFreezerArgs(varMap)) {
                RecipeRegistryComm.addFreezerRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables", this.modName);
            }
        } else if (type.equalsIgnoreCase("printer")) {
            if (RecipeConditions.hasPrinterArgs(varMap)) {
                RecipeRegistryComm.addPrinterRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("toaster")) {
            if (RecipeConditions.hasToasterArgs(varMap)) {
                RecipeRegistryComm.addToasterRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("choppingboard")) {
            if (RecipeConditions.hasChoppingBoardArgs(varMap)) {
                RecipeRegistryComm.addChoppingBoardRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("blender")) {
            if (RecipeConditions.hasBlenderArgs(varMap)) {
                RecipeRegistryComm.addBlenderRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("microwave")) {
            if (RecipeConditions.hasMicrowaveArgs(varMap)) {
                RecipeRegistryComm.addMicrowaveRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("washingmachine")) {
            if (RecipeConditions.hasWashingMachineArgs(varMap)) {
                RecipeRegistryComm.addWashingMachineRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (type.equalsIgnoreCase("dishwasher")) {
            if (RecipeConditions.hasDishwasherArgs(varMap)) {
                RecipeRegistryComm.addDishwasherRecipe(RecipeData.convertFrom(varMap), 2);
            } else if (ConfigurationHandler.api_debug) {
                RecipeUtil.printRequired(type, "Missing required variables for " + type, this.modName);
            }
        } else if (ConfigurationHandler.api_debug) {
            System.err.println("## RecipeAPI Error Report ##");
            System.err.println("From Mod: " + this.modName);
            System.err.println("Description:  The mod '" + this.modName + "' is trying to add a non existing recipe type '" + type + "'.");
            System.err.println("Type: " + type + " (Unknown)");
        }
        varMap.clear();
        varMap = null;
    }

    @Override
    public void registerRecipe(RecipeType type, RecipeVariables variables) {
        this.registerRecipe(type.toString(), variables);
    }
}

