/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.tileentity;

import com.zerofall.ezstorage.block.BlockCraftingBox;
import com.zerofall.ezstorage.block.BlockInputPort;
import com.zerofall.ezstorage.block.BlockOutputPort;
import com.zerofall.ezstorage.block.BlockSearchBox;
import com.zerofall.ezstorage.block.BlockStorage;
import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.block.StorageMultiblock;
import com.zerofall.ezstorage.init.EZBlocks;
import com.zerofall.ezstorage.tileentity.TileEntityInputPort;
import com.zerofall.ezstorage.tileentity.TileEntityOutputPort;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZStorageUtils;
import com.zerofall.ezstorage.util.ItemGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Logger;

public class TileEntityStorageCore
extends TileEntity
implements ITickable {
    public static Logger log = FMLLog.getLogger();
    public EZInventory inventory;
    Set<BlockRef> multiblock = new HashSet<BlockRef>();
    private boolean firstTick = false;
    public boolean hasCraftBox = false;
    public boolean hasSearchBox = false;
    public boolean disabled = false;

    public TileEntityStorageCore() {
        this.inventory = new EZInventory();
    }

    public ItemStack input(ItemStack stack) {
        ItemStack result = this.inventory.input(stack);
        this.field_145850_b.func_175689_h(this.field_174879_c);
        this.func_70296_d();
        return result;
    }

    public ItemStack getRandomStack() {
        ItemStack result = this.inventory.getItemsAt(0, 0);
        this.field_145850_b.func_175689_h(this.field_174879_c);
        this.func_70296_d();
        return result;
    }

    public void sortInventory() {
        this.inventory.sort();
        this.updateTileEntity();
    }

    public void updateTileEntity() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
        this.func_70296_d();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), nbtTag);
    }

    public void func_145841_b(NBTTagCompound paramNBTTagCompound) {
        super.func_145841_b(paramNBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.slotCount(); ++i) {
            ItemGroup group = this.inventory.inventory.get(i);
            if (group == null || group.itemStack == null || group.count <= 0L) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Index", (byte)i);
            group.itemStack.func_77955_b(nbttagcompound1);
            nbttagcompound1.func_74772_a("InternalCount", group.count);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        paramNBTTagCompound.func_74782_a("Internal", (NBTBase)nbttaglist);
        paramNBTTagCompound.func_74772_a("InternalMax", this.inventory.maxItems);
        paramNBTTagCompound.func_74757_a("hasSearchBox", this.hasSearchBox);
        paramNBTTagCompound.func_74757_a("isDisabled", this.disabled);
    }

    public void func_145839_a(NBTTagCompound paramNBTTagCompound) {
        long maxItems;
        super.func_145839_a(paramNBTTagCompound);
        NBTTagList nbttaglist = paramNBTTagCompound.func_150295_c("Internal", 10);
        if (nbttaglist != null) {
            this.inventory.inventory = new ArrayList<ItemGroup>();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Index") & 0xFF;
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                long count = nbttagcompound1.func_74763_f("InternalCount");
                ItemGroup group = new ItemGroup(stack, count);
                this.inventory.inventory.add(group);
            }
        }
        this.inventory.maxItems = maxItems = paramNBTTagCompound.func_74763_f("InternalMax");
        this.hasSearchBox = paramNBTTagCompound.func_74767_n("hasSearchBox");
        this.disabled = paramNBTTagCompound.func_74767_n("isDisabled");
    }

    public void scanMultiblock() {
        this.inventory.maxItems = 0L;
        this.hasCraftBox = false;
        this.hasSearchBox = false;
        this.multiblock = new HashSet<BlockRef>();
        BlockRef ref = new BlockRef(this);
        this.multiblock.add(ref);
        this.getValidNeighbors(ref);
        for (BlockRef blockRef : this.multiblock) {
            if (!(blockRef.block instanceof BlockStorage)) continue;
            BlockStorage sb = (BlockStorage)blockRef.block;
            this.inventory.maxItems += (long)sb.getCapacity();
        }
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    private void getValidNeighbors(BlockRef br) {
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.pos.func_177958_n(), br.pos.func_177956_o(), br.pos.func_177952_p(), this.field_145850_b);
        for (BlockRef blockRef : neighbors) {
            TileEntity entity;
            if (!(blockRef.block instanceof StorageMultiblock) || !this.multiblock.add(blockRef) || !this.validateSystem()) continue;
            if (blockRef.block instanceof BlockInputPort) {
                entity = (TileEntityInputPort)this.field_145850_b.func_175625_s(blockRef.pos);
                entity.core = this;
            }
            if (blockRef.block instanceof BlockOutputPort) {
                entity = (TileEntityOutputPort)this.field_145850_b.func_175625_s(blockRef.pos);
                ((TileEntityOutputPort)entity).core = this;
            }
            if (blockRef.block instanceof BlockCraftingBox) {
                this.hasCraftBox = true;
            }
            if (blockRef.block instanceof BlockSearchBox) {
                this.hasSearchBox = true;
            }
            this.getValidNeighbors(blockRef);
        }
    }

    public boolean validateSystem() {
        int count = 0;
        for (BlockRef ref : this.multiblock) {
            if (ref.block instanceof BlockStorageCore) {
                ++count;
            }
            if (count <= 1) continue;
            if (this.field_145850_b.field_72995_K) {
                if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("You can only have 1 Storage Core per system!"));
                }
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == EZBlocks.storage_core) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack(EZBlocks.storage_core)));
            }
            return false;
        }
        return true;
    }

    public boolean isPartOfMultiblock(BlockRef blockRef) {
        return this.multiblock != null && this.multiblock.contains(blockRef);
    }

    public void func_73660_a() {
        if (!this.firstTick && this.field_145850_b != null) {
            this.firstTick = true;
            this.scanMultiblock();
        }
    }
}

