/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.logger;

import alexndr.api.core.APISettings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelper {
    private static Logger logger;
    private static boolean verbose;

    public static void loggerSetup() {
        verbose = APISettings.verboseLogging.asBoolean();
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void info(String message) {
        logger = LogManager.getLogger((String)"SimpleCore");
        logger.log(Level.INFO, message);
    }

    public static void info(String loggerName, String message) {
        logger = LogManager.getLogger((String)loggerName);
        logger.log(Level.INFO, message);
    }

    public static void warning(String message) {
        logger = LogManager.getLogger((String)"SimpleCore");
        logger.log(Level.WARN, message);
    }

    public static void warning(String loggerName, String message) {
        logger = LogManager.getLogger((String)loggerName);
        logger.log(Level.WARN, message);
    }

    public static void severe(String message) {
        logger = LogManager.getLogger((String)"SimpleCore");
        logger.log(Level.ERROR, message);
    }

    public static void severe(String loggerName, String message) {
        logger = LogManager.getLogger((String)loggerName);
        logger.log(Level.ERROR, message);
    }

    public static void verbose(String message) {
        if (verbose) {
            logger = LogManager.getLogger((String)"SimpleCore");
            logger.log(Level.INFO, message);
        }
    }

    public static void verbose(String loggerName, String message) {
        if (verbose) {
            logger = LogManager.getLogger((String)loggerName);
            logger.log(Level.INFO, message);
        }
    }

    public static void verboseException(Exception e) {
        if (verbose) {
            e.printStackTrace();
        }
    }
}

