/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.config.types.ConfigItem;
import alexndr.api.content.items.SimpleBucketType;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SimpleBucket
extends ItemBucket {
    private Plugin plugin;
    private ContentCategories.Item category = ContentCategories.Item.OTHER;
    private ConfigItem entry;
    private List<String> toolTipStrings = Lists.newArrayList();
    private Block liquid;
    private SimpleBucketType bucketType;

    public SimpleBucket(Plugin plugin, Block liquidBlock, SimpleBucketType type) {
        super(liquidBlock);
        this.plugin = plugin;
        this.liquid = liquidBlock;
        this.bucketType = type;
    }

    public SimpleBucket setUnlocalizedName(String itemName) {
        super.func_77655_b(itemName);
        GameRegistry.registerItem((Item)this, (String)itemName);
        ContentRegistry.registerItem(this.plugin, (Item)this, itemName, this.category);
        return this;
    }

    public ConfigItem getConfigEntry() {
        return this.entry;
    }

    public SimpleBucket setConfigEntry(ConfigItem entry) {
        this.entry = entry;
        this.func_77625_d(entry.getStackSize());
        this.setAdditionalProperties();
        return this;
    }

    public SimpleBucket addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public void setAdditionalProperties() {
        if (this.entry.getValueByName("CreativeTab") != null && this.entry.getValueByName("CreativeTab").isActive()) {
            this.func_77637_a(this.entry.getCreativeTab());
        }
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        boolean flag = this.liquid == Blocks.field_150350_a;
        MovingObjectPosition movingobjectposition = this.func_77621_a(worldIn, playerIn, flag);
        if (movingobjectposition == null) {
            return itemStackIn;
        }
        ItemStack ret = ForgeEventFactory.onBucketUse((EntityPlayer)playerIn, (World)worldIn, (ItemStack)itemStackIn, (MovingObjectPosition)movingobjectposition);
        if (ret != null) {
            return ret;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos blockpos = movingobjectposition.func_178782_a();
            if (!worldIn.func_175660_a(playerIn, blockpos)) {
                return itemStackIn;
            }
            if (flag) {
                if (!playerIn.func_175151_a(blockpos.func_177972_a(movingobjectposition.field_178784_b), movingobjectposition.field_178784_b, itemStackIn)) {
                    return itemStackIn;
                }
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                Material material = iblockstate.func_177230_c().func_149688_o();
                if (material.func_76224_d() && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    Block liquid = iblockstate.func_177230_c();
                    if (this.bucketType.getLiquidsList().contains(liquid) && this.bucketType.doesVariantExist(liquid)) {
                        worldIn.func_175698_g(blockpos);
                        return this.giveNewBucket(itemStackIn, playerIn, this.bucketType.getBucketFromLiquid(liquid));
                    }
                    if (material == Material.field_151587_i && this.bucketType.getDestroyOnLava()) {
                        if (playerIn.field_71075_bZ.field_75098_d) {
                            return itemStackIn;
                        }
                        --itemStackIn.field_77994_a;
                        worldIn.func_72908_a((double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f), "random.fizz", 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                    }
                }
            } else {
                if (this.liquid == Blocks.field_150350_a) {
                    return new ItemStack(Items.field_151133_ar);
                }
                BlockPos blockpos1 = blockpos.func_177972_a(movingobjectposition.field_178784_b);
                if (!playerIn.func_175151_a(blockpos1, movingobjectposition.field_178784_b, itemStackIn)) {
                    return itemStackIn;
                }
                if (this.func_180616_a(worldIn, blockpos1) && !playerIn.field_71075_bZ.field_75098_d && this.bucketType.doesVariantExist(Blocks.field_150350_a)) {
                    return new ItemStack(this.bucketType.getBucketFromLiquid(Blocks.field_150350_a));
                }
            }
        }
        return itemStackIn;
    }

    private ItemStack giveNewBucket(ItemStack itemstack, EntityPlayer player, Item bucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return itemstack;
        }
        if (--itemstack.field_77994_a <= 0) {
            return new ItemStack(bucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(bucket))) {
            player.func_71019_a(new ItemStack(bucket, 1, 0), false);
        }
        return itemstack;
    }
}

