/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.blocks;

import alexndr.api.config.types.ConfigBlock;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SimpleBlock
extends Block {
    protected Plugin plugin;
    protected Material material;
    protected ContentCategories.Block category;
    protected ConfigBlock entry;

    public SimpleBlock(Plugin plugin, Material material, ContentCategories.Block category) {
        super(material);
        this.plugin = plugin;
        this.material = material;
        this.category = category;
    }

    public SimpleBlock setUnlocalizedName(String blockName) {
        super.func_149663_c(blockName);
        GameRegistry.registerBlock((Block)this, (String)blockName);
        ContentRegistry.registerBlock(this.plugin, this, blockName, this.category);
        return this;
    }

    public ConfigBlock getConfigEntry() {
        return this.entry;
    }

    public SimpleBlock setConfigEntry(ConfigBlock entry) {
        this.entry = entry;
        this.func_149711_c(entry.getHardness());
        this.func_149752_b(entry.getResistance());
        this.func_149715_a(entry.getLightValue());
        this.setHarvestLevel(entry.getHarvestTool(), entry.getHarvestLevel());
        this.func_149647_a(entry.getCreativeTab());
        this.setAdditionalProperties();
        return this;
    }

    public SimpleBlock addToolTip(String toolTip) {
        TooltipHelper.addTooltipToBlock(this, toolTip);
        return this;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.entry.getValueByName("DropItem") != null && this.entry.getValueByName("DropItem").isActive() && this.entry.getDropItem() && this.entry.getValueByName("ItemToDrop") != null && this.entry.getValueByName("ItemToDrop").isActive()) {
            return this.entry.getItemToDrop();
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(Random random) {
        if (this.entry.getDropItem() && this.entry.getValueByName("DropItem").isActive() && this.entry.getValueByName("QuantityToDrop") != null && this.entry.getValueByName("QuantityToDrop").isActive()) {
            return this.entry.getQuantityToDrop();
        }
        return 1;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
        if (this.func_180660_a(state, worldIn.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            int amount = MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)16, (int)33);
            this.func_180637_b(worldIn, pos, amount);
        }
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0 && this.func_180660_a((IBlockState)this.func_176194_O().func_177619_a().iterator().next(), random, fortune) != Item.func_150898_a((Block)this)) {
            int var = random.nextInt(fortune + 2) - 1;
            if (var < 0) {
                var = 0;
            }
            return this.func_149745_a(random) * (var + 1);
        }
        return this.func_149745_a(random);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        if (this.entry.getValueByName("FireSource") != null && this.entry.getValueByName("FireSource").isActive()) {
            return this.entry.getFireSource();
        }
        return false;
    }

    public boolean isLeaves(IBlockAccess world, BlockPos pos) {
        if (this.entry.getValueByName("IsLeaves") != null && this.entry.getValueByName("IsLeaves").isActive()) {
            return this.entry.getFireSource();
        }
        return false;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        if (this.entry.getValueByName("IsWood") != null && this.entry.getValueByName("IsWood").isActive()) {
            return this.entry.getIsWood();
        }
        return false;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beaconPos) {
        if (this.entry.getValueByName("BeaconBase") != null && this.entry.getValueByName("BeaconBase").isActive()) {
            return this.entry.getIsLeaves();
        }
        return false;
    }

    public void setAdditionalProperties() {
        if (this.entry.getValueByName("CreativeTab") != null && this.entry.getValueByName("CreativeTab").isActive()) {
            this.func_149647_a(this.entry.getCreativeTab());
        }
        if (this.entry.getValueByName("SoundType") != null && this.entry.getValueByName("SoundType").isActive()) {
            this.func_149672_a(this.entry.getSoundType());
        }
        if (this.entry.getValueByName("Unbreakable") != null && this.entry.getValueByName("Unbreakable").isActive()) {
            this.func_149722_s();
        }
    }
}

