/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.config.types.ConfigValue;
import alexndr.api.registry.ContentRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;

public class ConfigTool
extends ConfigEntry {
    private List<ConfigValue> valuesList = Lists.newArrayList();
    private ConfigValue uses = new ConfigValue("Uses").setCurrentValue("0");
    private ConfigValue harvestLevel = new ConfigValue("HarvestLevel").setCurrentValue("0");
    private ConfigValue harvestSpeed = new ConfigValue("HarvestSpeed").setCurrentValue("0.0F");
    private ConfigValue damageVsEntity = new ConfigValue("DamageVsEntity").setCurrentValue("0.0F");
    private ConfigValue enchantability = new ConfigValue("Enchantability").setCurrentValue("0");
    private ConfigValue creativeTab = new ConfigValue("CreativeTab");
    private ConfigValue render3D = new ConfigValue("RenderIn3D");
    private ConfigValue repairMaterial = new ConfigValue("RepairMaterial");

    public ConfigTool(String name, String category) {
        super(name, category);
        this.valuesList.addAll(Lists.newArrayList((Object[])new ConfigValue[]{this.uses, this.harvestLevel, this.harvestSpeed, this.damageVsEntity, this.enchantability, this.creativeTab, this.render3D, this.repairMaterial}));
        super.setValuesList(this.valuesList);
    }

    @Override
    public List<ConfigValue> getValuesList() {
        return this.valuesList;
    }

    @Override
    public void setValuesList(List<ConfigValue> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public ConfigValue createNewValue(String valueName) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        this.valuesList.add(value);
        return value;
    }

    @Override
    public ConfigTool createNewValue(String valueName, String dataType, String currentValue, String defaultValue) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        value.setDataType(dataType);
        value.setCurrentValue(currentValue);
        value.setDefaultValue(defaultValue);
        this.valuesList.add(value);
        return this;
    }

    @Override
    public ConfigValue getValueByName(String valueName) {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    public int getUses() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.uses.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigTool setUses(int uses) {
        this.uses.setActive().setDataType("@I").setCurrentValue("" + uses).setDefaultValue("" + uses);
        return this;
    }

    public int getHarvestLevel() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.harvestLevel.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigTool setHarvestLevel(int harvestLevel) {
        this.harvestLevel.setActive().setDataType("@I").setCurrentValue("" + harvestLevel).setDefaultValue("" + harvestLevel);
        return this;
    }

    public float getHarvestSpeed() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.harvestSpeed.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigTool setHarvestSpeed(float harvestSpeed) {
        this.harvestSpeed.setActive().setDataType("@F").setCurrentValue("" + harvestSpeed).setDefaultValue("" + harvestSpeed);
        return this;
    }

    public float getDamageVsEntity() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.damageVsEntity.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigTool setDamageVsEntity(float damageVsEntity) {
        this.damageVsEntity.setActive().setDataType("@F").setCurrentValue("" + damageVsEntity).setDefaultValue("" + damageVsEntity);
        return this;
    }

    public int getEnchantability() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.enchantability.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigTool setEnchantability(int enchantability) {
        this.enchantability.setActive().setDataType("@I").setCurrentValue("" + enchantability).setDefaultValue("" + enchantability);
        return this;
    }

    public CreativeTabs getCreativeTab() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.creativeTab.getName()) || !ContentRegistry.doesTabExist(value.getCurrentValue())) continue;
            return ContentRegistry.getTab(value.getCurrentValue());
        }
        return null;
    }

    public ConfigTool setCreativeTab(String tabName) {
        this.creativeTab.setActive().setDataType("@S").setCurrentValue(tabName).setDefaultValue(tabName);
        return this;
    }

    public boolean getRender3D() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.render3D.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return true;
    }

    public ConfigTool setRender3D(boolean render3d) {
        this.render3D.setActive().setDataType("@B").setCurrentValue("" + render3d).setDefaultValue("" + render3d);
        return this;
    }

    public String getRepairMaterial() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.repairMaterial.getName())) continue;
            return value.getCurrentValue();
        }
        return "";
    }

    public ConfigTool setRepairMaterial(String repairMaterial) {
        this.repairMaterial.setActive().setDataType("@S").setCurrentValue(repairMaterial).setDefaultValue(repairMaterial);
        return this;
    }
}

