/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigArmor;
import alexndr.api.config.types.ConfigBlock;
import alexndr.api.config.types.ConfigItem;
import alexndr.api.config.types.ConfigTool;
import alexndr.api.config.types.ConfigValue;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;

public class ConfigEntry {
    private String name;
    private String category;
    private List<ConfigValue> valuesList = Lists.newArrayList();
    private static HashMap<String, ConfigEntry> entryNameMap = new HashMap();

    public ConfigEntry(String name, String category) {
        this.name = name;
        this.category = category;
        entryNameMap.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public List<ConfigValue> getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List<ConfigValue> valuesList) {
        this.valuesList = valuesList;
    }

    public ConfigValue createNewValue(String valueName) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        this.valuesList.add(value);
        return value;
    }

    public ConfigEntry createNewValue(String valueName, String dataType, String currentValue, String defaultValue) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        value.setDataType(dataType);
        value.setCurrentValue(currentValue);
        value.setDefaultValue(defaultValue);
        this.valuesList.add(value);
        return this;
    }

    public ConfigValue getValueByName(String valueName) {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    public static boolean doesEntryWithNameExist(String name) {
        return entryNameMap.containsKey(name);
    }

    public static ConfigEntry getEntryFromName(String name) {
        return entryNameMap.get(name);
    }

    public ConfigBlock asConfigBlock() {
        ConfigBlock block = new ConfigBlock(this.name, this.category);
        block.setValuesList(this.valuesList);
        return block;
    }

    public ConfigItem asConfigItem() {
        ConfigItem item = new ConfigItem(this.name, this.category);
        item.setValuesList(this.valuesList);
        return item;
    }

    public ConfigTool asConfigTool() {
        ConfigTool tool = new ConfigTool(this.name, this.category);
        tool.setValuesList(this.valuesList);
        return tool;
    }

    public ConfigArmor asConfigArmor() {
        ConfigArmor armor = new ConfigArmor(this.name, this.category);
        armor.setValuesList(this.valuesList);
        return armor;
    }
}

