/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.config.types.ConfigValue;
import com.google.common.collect.Lists;
import java.util.List;

public class ConfigArmor
extends ConfigEntry {
    private List<ConfigValue> valuesList = Lists.newArrayList();
    private ConfigValue durability = new ConfigValue("Durability");
    private ConfigValue enchantability = new ConfigValue("Enchantability");
    private ConfigValue helmReduction = new ConfigValue("HelmetReduction");
    private ConfigValue chestReduction = new ConfigValue("ChestplateReduction");
    private ConfigValue legsReduction = new ConfigValue("LeggingsReduction");
    private ConfigValue bootsReduction = new ConfigValue("BootsReduction");
    private ConfigValue repairMaterial = new ConfigValue("RepairMaterial");

    public ConfigArmor(String name, String category) {
        super(name, category);
        this.valuesList.addAll(Lists.newArrayList((Object[])new ConfigValue[]{this.durability, this.enchantability, this.helmReduction, this.chestReduction, this.legsReduction, this.bootsReduction}));
        super.setValuesList(this.valuesList);
    }

    @Override
    public List<ConfigValue> getValuesList() {
        return this.valuesList;
    }

    @Override
    public void setValuesList(List<ConfigValue> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public ConfigValue createNewValue(String valueName) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        this.valuesList.add(value);
        return value;
    }

    @Override
    public ConfigArmor createNewValue(String valueName, String dataType, String currentValue, String defaultValue) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        value.setDataType(dataType);
        value.setCurrentValue(currentValue);
        value.setDefaultValue(defaultValue);
        this.valuesList.add(value);
        return this;
    }

    @Override
    public ConfigValue getValueByName(String valueName) {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    public int getDurability() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.durability.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setDurability(int durability) {
        this.durability.setActive().setDataType("@I").setCurrentValue("" + durability).setDefaultValue("" + durability);
        return this;
    }

    public int getEnchantability() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.enchantability.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setEnchantability(int enchantability) {
        this.enchantability.setActive().setDataType("@I").setCurrentValue("" + enchantability).setDefaultValue("" + enchantability);
        return this;
    }

    public int getHelmReduction() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.helmReduction.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setHelmReduction(int helmReduction) {
        this.helmReduction.setActive().setDataType("@I").setCurrentValue("" + helmReduction).setDefaultValue("" + helmReduction);
        return this;
    }

    public int getChestReduction() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.chestReduction.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setChestReduction(int chestReduction) {
        this.chestReduction.setActive().setDataType("@I").setCurrentValue("" + chestReduction).setDefaultValue("" + chestReduction);
        return this;
    }

    public int getLegsReduction() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.legsReduction.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setLegsReduction(int legsReduction) {
        this.legsReduction.setActive().setDataType("@I").setCurrentValue("" + legsReduction).setDefaultValue("" + legsReduction);
        return this;
    }

    public int getBootsReduction() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.bootsReduction.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigArmor setBootsReduction(int bootsReduction) {
        this.bootsReduction.setActive().setDataType("@I").setCurrentValue("" + bootsReduction).setDefaultValue("" + bootsReduction);
        return this;
    }

    public String getRepairMaterial() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.repairMaterial.getName())) continue;
            return value.getCurrentValue();
        }
        return "";
    }

    public ConfigArmor setRepairMaterial(String repairMaterial) {
        this.repairMaterial.setActive().setDataType("@S").setCurrentValue(repairMaterial).setDefaultValue(repairMaterial);
        return this;
    }
}

