/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config;

import alexndr.api.config.ConfigReader;
import alexndr.api.config.ConfigWriter;
import alexndr.api.config.types.ConfigEntry;
import alexndr.api.logger.LogHelper;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class Configuration {
    private File file;
    private String modName;
    private List<ConfigEntry> writeEntryList = Lists.newArrayList();
    private List<ConfigEntry> loadEntryList = Lists.newArrayList();

    public ConfigEntry get(ConfigEntry configEntry) {
        for (ConfigEntry entry : this.loadEntryList) {
            if (!entry.getName().equals(configEntry.getName())) continue;
            this.writeEntryList.add(entry);
            return entry;
        }
        this.writeEntryList.add(configEntry);
        return configEntry;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getModName() {
        return this.modName;
    }

    public void setModName(String modName) {
        this.modName = modName;
    }

    public List<ConfigEntry> getWriteEntryList() {
        return this.writeEntryList;
    }

    public List<ConfigEntry> getLoadEntryList() {
        return this.loadEntryList;
    }

    public void load() {
        if (!this.file.exists()) {
            LogHelper.verbose("No config file exists for " + this.modName + ". Creating a new one at \"" + this.file.getPath() + "\"");
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (Exception e) {
                LogHelper.warning("\tFailed creating config file. Please retry");
                LogHelper.verboseException(e);
            }
            finally {
                LogHelper.verbose("\tConfig file created successfully");
            }
        } else {
            LogHelper.verbose("Loading config file belonging to " + this.modName + " @ \"" + this.file.getPath() + "\"");
            ConfigReader reader = new ConfigReader();
            reader.setFile(this.file);
            this.loadEntryList = reader.readConfig();
            LogHelper.verbose("\tConfig file for " + this.modName + " loaded successfully");
        }
    }

    public void save() {
        LogHelper.verbose("\tSaving config file.");
        ConfigWriter writer = new ConfigWriter();
        writer.setFile(this.file);
        writer.setEntriesList(this.writeEntryList);
        writer.writeConfig();
        LogHelper.verbose("\tConfig file saved successfully");
    }
}

