/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.logger.LogHelper;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.JDOMParseException;
import org.jdom2.input.SAXBuilder;

public class ConfigReader {
    private File file;
    private String modName = "";
    private List<ConfigEntry> loadedEntriesList = Lists.newArrayList();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getModName() {
        return this.modName;
    }

    public void setModName(String modName) {
        this.modName = modName;
    }

    public List<ConfigEntry> readConfig() {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.file);
            Element root = doc.getRootElement();
            List<Element> categories = root.getChildren();
            for (Element category : categories) {
                String cat = category.getName();
                List<Element> types = category.getChildren();
                for (Element type : types) {
                    String name = type.getAttributeValue("Name");
                    List<Content> contents = type.getContent();
                    ArrayList properties = Lists.newArrayList();
                    ArrayList comments = Lists.newArrayList();
                    for (Content content : contents) {
                        if (content instanceof Element) {
                            properties.add((Element)content);
                        }
                        if (!(content instanceof Comment)) continue;
                        comments.add((Comment)content);
                    }
                    ConfigEntry entry = new ConfigEntry(name, cat);
                    for (Element property : properties) {
                        String defaultVal = "";
                        String dataType = "";
                        if (property.getAttribute("DataType") != null) {
                            dataType = property.getAttributeValue("DataType");
                        }
                        if (property.getAttribute("Default") != null) {
                            defaultVal = property.getAttributeValue("Default");
                        }
                        entry.createNewValue(property.getName()).setActive().setDataType(dataType).setCurrentValue(property.getValue()).setDefaultValue(defaultVal);
                    }
                    this.loadedEntriesList.add(entry);
                }
            }
        }
        catch (Exception e) {
            if (this.file.length() != 0L) {
                LogHelper.severe("\tInvalid config file. Please retry or delete the file.");
            }
            if (e instanceof JDOMParseException) {
                LogHelper.warning("\tThe config file is incorrectly formatted. It should be auto-generated in the correct form. If this doesn't work, please delete the file and retry.");
            }
            LogHelper.warning("\tThe config file is empty. It should auto-generate. If not, please delete the file and retry.");
        }
        return this.loadedEntriesList;
    }
}

