/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.gui.CraftingGridHelper;
import mezz.jei.gui.DrawableAnimated;
import mezz.jei.gui.DrawableBlank;
import mezz.jei.gui.DrawableResource;
import mezz.jei.util.Log;
import mezz.jei.util.TickTimer;
import net.minecraft.util.ResourceLocation;

public class GuiHelper
implements IGuiHelper {
    private final IDrawableStatic slotDrawable;

    public GuiHelper() {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.slotDrawable = this.createDrawable(location, 55, 16, 18, 18);
    }

    @Override
    @Nonnull
    public IDrawableStatic createDrawable(@Nullable ResourceLocation resourceLocation, int u, int v, int width, int height) {
        if (resourceLocation == null) {
            Log.error("Null resourceLocation, returning blank drawable", new NullPointerException());
            return this.createBlankDrawable(width, height);
        }
        return new DrawableResource(resourceLocation, u, v, width, height);
    }

    @Override
    @Nonnull
    public IDrawableStatic createDrawable(@Nullable ResourceLocation resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        if (resourceLocation == null) {
            Log.error("Null resourceLocation, returning blank drawable", new NullPointerException());
            return this.createBlankDrawable(width, height);
        }
        return new DrawableResource(resourceLocation, u, v, width, height, paddingTop, paddingBottom, paddingLeft, paddingRight);
    }

    @Override
    @Nonnull
    public IDrawableAnimated createAnimatedDrawable(@Nullable IDrawableStatic drawable, int ticksPerCycle, @Nullable IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        if (drawable == null) {
            Log.error("Null drawable, returning blank drawable", new NullPointerException());
            return new DrawableBlank(0, 0);
        }
        if (startDirection == null) {
            Log.error("Null startDirection, defaulting to Top", new NullPointerException());
            startDirection = IDrawableAnimated.StartDirection.TOP;
        }
        if (inverted) {
            startDirection = startDirection == IDrawableAnimated.StartDirection.TOP ? IDrawableAnimated.StartDirection.BOTTOM : (startDirection == IDrawableAnimated.StartDirection.BOTTOM ? IDrawableAnimated.StartDirection.TOP : (startDirection == IDrawableAnimated.StartDirection.LEFT ? IDrawableAnimated.StartDirection.RIGHT : IDrawableAnimated.StartDirection.LEFT));
        }
        int tickTimerMaxValue = startDirection == IDrawableAnimated.StartDirection.TOP || startDirection == IDrawableAnimated.StartDirection.BOTTOM ? drawable.getHeight() : drawable.getWidth();
        ITickTimer tickTimer = this.createTickTimer(ticksPerCycle, tickTimerMaxValue, !inverted);
        return new DrawableAnimated(drawable, tickTimer, startDirection);
    }

    @Override
    @Nonnull
    public IDrawableStatic getSlotDrawable() {
        return this.slotDrawable;
    }

    @Override
    @Nonnull
    public IDrawableStatic createBlankDrawable(int width, int height) {
        return new DrawableBlank(width, height);
    }

    @Override
    @Nonnull
    public ICraftingGridHelper createCraftingGridHelper(int craftInputSlot1, int craftOutputSlot) {
        return new CraftingGridHelper(craftInputSlot1, craftOutputSlot);
    }

    @Override
    @Nonnull
    public ITickTimer createTickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        return new TickTimer(ticksPerCycle, maxValue, countDown);
    }
}

