/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.permission;

import code.elix_x.excore.utils.nbt.mbt.MBT;
import code.elix_x.mods.fei.ForeverEnoughItemsBase;
import code.elix_x.mods.fei.api.permission.FEIPermissionLevel;
import code.elix_x.mods.fei.api.permission.IFEIPermissionsManager;
import code.elix_x.mods.fei.net.SyncPermissionsManagerPacket;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FEIPermissionsManager
extends WorldSavedData
implements IFEIPermissionsManager {
    public static final String NAME = "FEIPermissions";
    public static final MBT mbt = new MBT();
    private Map<UUID, FEIPermissionLevel> permissions = new HashMap<UUID, FEIPermissionLevel>();

    public static FEIPermissionLevel getPermissionLevels(EntityPlayer player) {
        return FEIPermissionsManager.get(player.field_70170_p).getPermissionLevel(player);
    }

    public static void setPermissionLevels(EntityPlayer player, FEIPermissionLevel level) {
        FEIPermissionsManager.get(player.field_70170_p).setPermissionLevel(player, level);
        FEIPermissionsManager.syncWithAll();
    }

    public static void syncWith(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        FEIPermissionsManager.get(player.field_70170_p).func_76187_b(nbt);
        ForeverEnoughItemsBase.net.sendTo((IMessage)new SyncPermissionsManagerPacket(nbt), (EntityPlayerMP)player);
    }

    public static void syncWithAll() {
        NBTTagCompound nbt = new NBTTagCompound();
        FEIPermissionsManager.get(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_()).func_76187_b(nbt);
        ForeverEnoughItemsBase.net.sendToAll((IMessage)new SyncPermissionsManagerPacket(nbt));
    }

    @SideOnly(value=Side.CLIENT)
    public static void onSync(SyncPermissionsManagerPacket packet) {
        FEIPermissionsManager.get((World)Minecraft.func_71410_x().field_71441_e).func_76184_a(packet.nbt);
    }

    public static FEIPermissionsManager get(World world) {
        FEIPermissionsManager manager = (FEIPermissionsManager)world.func_175693_T().func_75742_a(FEIPermissionsManager.class, NAME);
        if (manager == null) {
            manager = new FEIPermissionsManager(NAME);
            world.func_175693_T().func_75745_a(NAME, (WorldSavedData)manager);
        }
        return manager;
    }

    public FEIPermissionsManager(String name) {
        super(name);
    }

    public FEIPermissionLevel getPermissionLevel(UUID player) {
        return this.permissions.get(player) == null ? FEIPermissionLevel.USER : this.permissions.get(player);
    }

    @Override
    public FEIPermissionLevel getPermissionLevel(EntityPlayer player) {
        return this.getPermissionLevel(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public void setPermissionLevel(UUID player, FEIPermissionLevel level) {
        this.permissions.put(player, level);
        this.func_76185_a();
    }

    public void setPermissionLevel(EntityPlayer player, FEIPermissionLevel level) {
        this.setPermissionLevel(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()), level);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.permissions = (Map)mbt.fromNBT(nbt.func_74781_a("data"), HashMap.class, new Class[]{UUID.class, FEIPermissionLevel.class});
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74782_a("data", mbt.toNBT(this.permissions));
    }
}

