/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.jeioverride;

import code.elix_x.mods.fei.ForeverEnoughItemsBase;
import code.elix_x.mods.fei.config.FEIConfiguration;
import code.elix_x.mods.fei.net.FEIGiveItemStackPacket;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.ItemFilter;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackFast;
import mezz.jei.gui.ingredients.GuiItemStackFastList;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.network.packets.PacketJEI;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class ItemListOverlayOverride
extends ItemListOverlay {
    private static final int borderPadding = 2;
    private static final int searchHeight = 16;
    private static final int buttonSize = 20;
    private static final String nextLabel = ">";
    private static final String backLabel = "<";
    private static final int itemStackPadding = 1;
    private static final int itemStackWidth = GuiItemStackGroup.getWidth((int)1);
    private static final int itemStackHeight = GuiItemStackGroup.getHeight((int)1);
    private static int firstItemIndex = 0;
    @Nonnull
    private final ItemFilter itemFilter;
    @Nonnull
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers;
    private final GuiItemStackFastList guiItemStacks = new GuiItemStackFastList();
    private GuiButton nextButton;
    private GuiButton backButton;
    private GuiTextFieldFilter searchField;
    private String pageNumDisplayString;
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private GuiItemStackFast hovered = null;
    @Nullable
    private GuiProperties guiProperties;
    @Nullable
    private List<Rectangle> guiAreas;
    @Nullable
    IAdvancedGuiHandler advancedGuiHandler;
    private boolean open = false;
    private boolean canGiveItems;
    private boolean canDeleteItems;
    private boolean moveSearchFieldToCenter;
    private int searchFieldWidth;
    private int searchFieldHeight;

    public ItemListOverlayOverride(@Nonnull ItemFilter itemFilter, @Nonnull List<IAdvancedGuiHandler<?>> advancedGuiHandlers, boolean canGiveItems, boolean canDeleteItems, boolean moveSearchFieldToCenter, int searchFieldWidth, int searchFieldHeight) {
        super(itemFilter, advancedGuiHandlers);
        this.itemFilter = itemFilter;
        this.advancedGuiHandlers = advancedGuiHandlers;
        this.canGiveItems = canGiveItems;
        this.canDeleteItems = canDeleteItems;
        this.moveSearchFieldToCenter = moveSearchFieldToCenter;
        this.searchFieldWidth = searchFieldWidth;
        this.searchFieldHeight = searchFieldHeight;
    }

    public void initGui(@Nonnull GuiScreen guiScreen) {
        GuiProperties guiProperties = GuiProperties.create((GuiScreen)guiScreen);
        if (guiProperties == null) {
            return;
        }
        this.guiProperties = guiProperties;
        this.advancedGuiHandler = this.getAdvancedGuiHandler(guiScreen);
        if (this.advancedGuiHandler != null && guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            this.guiAreas = this.advancedGuiHandler.getGuiExtraAreas(guiContainer);
        } else {
            this.guiAreas = null;
        }
        int columns = this.getColumns();
        if (columns < 4) {
            this.close();
            return;
        }
        int rows = this.getRows();
        int xSize = columns * itemStackWidth;
        int xEmptySpace = guiProperties.getScreenWidth() - guiProperties.getGuiLeft() - guiProperties.getGuiXSize() - xSize;
        int leftEdge = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + xEmptySpace / 2;
        int rightEdge = leftEdge + xSize;
        int yItemButtonSpace = this.getItemButtonYSpace();
        int itemButtonsHeight = rows * itemStackHeight;
        int buttonStartY = 24 + (yItemButtonSpace - itemButtonsHeight) / 2;
        ItemListOverlayOverride.createItemButtons(this.guiItemStacks, this.guiAreas, leftEdge, buttonStartY, columns, rows);
        this.nextButton = new GuiButtonExt(0, rightEdge - 20, 2, 20, 20, nextLabel);
        this.backButton = new GuiButtonExt(1, leftEdge, 2, 20, 20, backLabel);
        if (this.moveSearchFieldToCenter) {
            int searchFieldY = guiProperties.getScreenHeight() - this.searchFieldHeight - 2 - 2;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.searchField = new GuiTextFieldFilter(0, fontRenderer, (guiProperties.getScreenWidth() - this.searchFieldWidth) / 2, searchFieldY, this.searchFieldWidth, this.searchFieldHeight);
            this.setKeyboardFocus(false);
            this.searchField.setItemFilter(this.itemFilter);
        } else {
            int searchFieldY = guiProperties.getScreenHeight() - this.searchFieldHeight - 2 - 2;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.searchField = new GuiTextFieldFilter(0, fontRenderer, rightEdge - this.searchFieldWidth - 2, searchFieldY, this.searchFieldWidth, this.searchFieldHeight);
            this.setKeyboardFocus(false);
            this.searchField.setItemFilter(this.itemFilter);
        }
        this.updateLayout();
        this.open();
    }

    @Nullable
    private IAdvancedGuiHandler<?> getAdvancedGuiHandler(@Nonnull GuiScreen guiScreen) {
        if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            for (IAdvancedGuiHandler<?> advancedGuiHandler : this.advancedGuiHandlers) {
                if (!advancedGuiHandler.getGuiContainerClass().isAssignableFrom(guiContainer.getClass())) continue;
                return advancedGuiHandler;
            }
        }
        return null;
    }

    public void updateGui(@Nonnull GuiScreen guiScreen) {
        if (this.guiProperties == null) {
            this.initGui(guiScreen);
        } else {
            GuiContainer guiContainer;
            List guiAreas;
            GuiProperties guiProperties = GuiProperties.create((GuiScreen)guiScreen);
            if (guiProperties == null) {
                return;
            }
            if (!this.guiProperties.equals((Object)guiProperties)) {
                this.initGui(guiScreen);
            } else if (this.advancedGuiHandler != null && guiScreen instanceof GuiContainer && !Objects.equals(this.guiAreas, guiAreas = this.advancedGuiHandler.getGuiExtraAreas(guiContainer = (GuiContainer)guiScreen))) {
                this.initGui((GuiScreen)guiContainer);
            }
        }
    }

    private static void createItemButtons(@Nonnull GuiItemStackFastList guiItemStacks, @Nullable List<Rectangle> guiAreas, int xStart, int yStart, int columnCount, int rowCount) {
        guiItemStacks.clear();
        for (int row = 0; row < rowCount; ++row) {
            int y = yStart + row * itemStackHeight;
            for (int column = 0; column < columnCount; ++column) {
                Rectangle stackArea;
                int x = xStart + column * itemStackWidth;
                GuiItemStackFast guiItemStackFast = new GuiItemStackFast(x, y, 1);
                if (guiAreas != null && ItemListOverlayOverride.intersects(guiAreas, stackArea = guiItemStackFast.getArea())) continue;
                guiItemStacks.add(guiItemStackFast);
            }
        }
    }

    private static boolean intersects(List<Rectangle> areas, Rectangle comparisonArea) {
        for (Rectangle area : areas) {
            if (!area.intersects(comparisonArea)) continue;
            return true;
        }
        return false;
    }

    private void updateLayout() {
        ImmutableList itemList = this.itemFilter.getItemList();
        this.guiItemStacks.set(firstItemIndex, (List)itemList);
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = this.getPageNum() + 1 + "/" + this.getPageCount();
        int pageDisplayWidth = fontRendererObj.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRendererObj.field_78288_b) / 2.0f);
        this.searchField.update();
    }

    private void nextPage() {
        int itemsCount = this.itemFilter.size();
        if (itemsCount == 0) {
            firstItemIndex = 0;
            return;
        }
        if ((firstItemIndex += this.guiItemStacks.size()) >= itemsCount) {
            firstItemIndex = 0;
        }
        this.updateLayout();
    }

    private void previousPage() {
        int itemsPerPage = this.guiItemStacks.size();
        if (itemsPerPage == 0) {
            firstItemIndex = 0;
            return;
        }
        int itemsCount = this.itemFilter.size();
        int pageNum = firstItemIndex / itemsPerPage;
        pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
        firstItemIndex = itemsPerPage * pageNum;
        this.updateLayout();
    }

    public void drawScreen(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isOpen()) {
            return;
        }
        GlStateManager.func_179140_f();
        minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
        this.searchField.func_146194_f();
        this.nextButton.func_146112_a(minecraft, mouseX, mouseY);
        this.backButton.func_146112_a(minecraft, mouseX, mouseY);
        GlStateManager.func_179084_k();
        if (this.shouldShowDeleteItemTooltip(minecraft)) {
            this.hovered = this.guiItemStacks.render(minecraft, false, mouseX, mouseY);
        } else {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            this.hovered = this.guiItemStacks.render(minecraft, mouseOver, mouseX, mouseY);
        }
        if (this.hovered != null) {
            RenderHelper.func_74520_c();
            this.hovered.drawHovered(minecraft);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179141_d();
    }

    private boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (this.canDeleteItems && FEIConfiguration.canDeleteItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player.field_71071_by.func_70445_o() != null) {
                return true;
            }
        }
        return false;
    }

    public void drawTooltips(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isOpen()) {
            return;
        }
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.shouldShowDeleteItemTooltip(minecraft)) {
            String deleteItem = Translator.translateToLocal((String)"jei.tooltip.delete.item");
            TooltipRenderer.drawHoveringText((Minecraft)minecraft, (String)deleteItem, (int)mouseX, (int)mouseY);
        }
        if (this.hovered != null) {
            this.hovered.drawTooltip(minecraft, mouseX, mouseY);
        }
    }

    public void handleTick() {
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.guiProperties == null || !this.isOpen()) {
            return false;
        }
        if (!(this.moveSearchFieldToCenter && this.searchField.isMouseOver(mouseX, mouseY) || mouseX >= this.guiProperties.getGuiLeft() + this.guiProperties.getGuiXSize())) {
            return false;
        }
        if (this.guiAreas != null) {
            for (Rectangle guiArea : this.guiAreas) {
                if (!guiArea.contains(mouseX, mouseY)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        Focus focus = this.guiItemStacks.getFocusUnderMouse(mouseX, mouseY);
        boolean key = Thread.currentThread().getStackTrace()[2].getMethodName().equals("getFocusUnderMouseForKey");
        if (focus != null && (key || Config.isEditModeEnabled() || !this.canGiveItems || !FEIConfiguration.canGiveItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g))) {
            this.setKeyboardFocus(false);
            return focus;
        }
        return null;
    }

    public boolean canSetFocusWithMouse() {
        return true;
    }

    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean buttonClicked;
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
            Focus f = this.guiItemStacks.getFocusUnderMouse(mouseX, mouseY);
            if (f != null && this.canGiveItems && FEIConfiguration.canGiveItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                ItemStack itemstack = f.getStack().func_77946_l();
                itemstack.field_77994_a = mouseButton == 0 ? itemstack.func_77976_d() : 1;
                ForeverEnoughItemsBase.net.sendToServer((IMessage)new FEIGiveItemStackPacket(itemstack));
                return true;
            }
        } else if (this.canDeleteItems && FEIConfiguration.canDeleteItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (itemStack != null) {
                player.field_71071_by.func_70437_b(null);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                JustEnoughItems.getProxy().sendPacketToServer((PacketJEI)packet);
                return true;
            }
        }
        if (buttonClicked = this.handleMouseClickedButtons(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return true;
        }
        return this.handleMouseClickedSearch(mouseX, mouseY, mouseButton);
    }

    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.nextPage();
            this.nextButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.previousPage();
            this.backButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedSearch(int mouseX, int mouseY, int mouseButton) {
        boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
        this.setKeyboardFocus(searchClicked);
        if (searchClicked && this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            this.updateLayout();
        }
        return searchClicked;
    }

    public boolean hasKeyboardFocus() {
        return this.searchField != null && this.searchField.func_146206_l();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        if (this.searchField != null) {
            this.searchField.func_146195_b(keyboardFocus);
        }
    }

    public boolean onKeyPressed(int keyCode) {
        if (this.hasKeyboardFocus()) {
            char character = Keyboard.getEventCharacter();
            boolean changed = this.searchField.func_146201_a(character, Keyboard.getEventKey());
            if (changed) {
                while (firstItemIndex >= this.itemFilter.size() && firstItemIndex > 0) {
                    this.previousPage();
                }
                this.updateLayout();
            }
            return changed || ChatAllowedCharacters.func_71566_a((char)character);
        }
        return false;
    }

    private int getItemButtonXSpace() {
        if (this.guiProperties == null) {
            return 0;
        }
        return this.guiProperties.getScreenWidth() - (this.guiProperties.getGuiLeft() + this.guiProperties.getGuiXSize() + 4);
    }

    private int getItemButtonYSpace() {
        if (this.guiProperties == null) {
            return 0;
        }
        return this.guiProperties.getScreenHeight() - (20 + (this.moveSearchFieldToCenter ? 0 : this.searchFieldHeight + 2) + 8);
    }

    private int getColumns() {
        return this.getItemButtonXSpace() / itemStackWidth;
    }

    private int getRows() {
        return this.getItemButtonYSpace() / itemStackHeight;
    }

    private int getPageCount() {
        int itemCount = this.itemFilter.size();
        int stacksPerPage = this.guiItemStacks.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        int pageCount = MathUtil.divideCeil((int)itemCount, (int)stacksPerPage);
        pageCount = Math.max(1, pageCount);
        return pageCount;
    }

    private int getPageNum() {
        int stacksPerPage = this.guiItemStacks.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        return firstItemIndex / stacksPerPage;
    }

    public void open() {
        this.open = true;
        this.setKeyboardFocus(false);
    }

    public void close() {
        this.open = false;
        this.setKeyboardFocus(false);
        Config.saveFilterText();
    }

    public boolean isOpen() {
        return this.open && Config.isOverlayEnabled();
    }

    @Nullable
    public ItemStack getStackUnderMouse() {
        if (this.hovered == null) {
            return null;
        }
        return this.hovered.getItemStack();
    }

    public void setFilterText(@Nullable String filterText) {
        if (filterText == null) {
            Log.error((String)"null filterText", (Object[])new Object[]{new NullPointerException()});
            return;
        }
        this.searchField.func_146180_a(filterText);
        Config.setFilterText((String)filterText);
    }

    @Nonnull
    public String getFilterText() {
        return this.itemFilter.getFilterText();
    }
}

