/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui.element;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.ListGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import code.elix_x.mods.fei.ForeverEnoughItemsBase;
import code.elix_x.mods.fei.api.events.FEIInventorySaveEvent;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.api.gui.elements.IConfigurableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.ISaveableFEIGuiElement;
import code.elix_x.mods.fei.api.permission.FEIPermissionLevel;
import code.elix_x.mods.fei.api.profile.Profile;
import code.elix_x.mods.fei.client.gui.FEIInventorySavesListSettingsGUI;
import code.elix_x.mods.fei.net.LoadInventoryPacket;
import code.elix_x.mods.fei.permission.FEIPermissionsManager;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FEIInventorySavesList
extends ListGuiElement<FEIGuiOverride>
implements ISaveableFEIGuiElement,
IConfigurableFEIGuiElement {
    public static final Logger logger = LogManager.getLogger((String)"Inventory Saves List");
    public static final Gson gson = new Gson();
    public RGBA textColor = new RGBA(255, 255, 255, 255);
    public boolean tooltipBackground = false;
    private FEIInventorySavesListLoadElement edit = null;

    public FEIInventorySavesList() {
        super("FEI Invetory Saves List", 0, 54, 64, 128, 20, 2, 2, new RGBA(0, 0, 0, 0));
    }

    @Override
    public void load(Profile profile, JsonObject json) {
        JsonData data = (JsonData)gson.fromJson((JsonElement)json, JsonData.class);
        this.xPos = data.xPos;
        this.yPos = data.yPos;
        this.width = data.width;
        this.height = data.height;
        this.borderX = data.borderX;
        this.borderY = data.borderY;
        this.scrollDistance = data.scrollDistance;
        this.clickTimeThreshold = data.clickTimeThreshold;
        this.clickDistanceThreshold = data.clickDistanceThreshold;
        this.backgroundColor = data.backgroundColor;
        this.textColor = data.textColor;
        this.tooltipBackground = data.tooltipBackground;
        File nbtd = new File(profile.getSaveDir(), "Inventory Saves.nbt");
        if (nbtd.exists()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(nbtd));
                NBTTagList list = (NBTTagList)nbt.func_74781_a("saves");
                this.reInitElements(list.func_74745_c() + 1);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    this.elements[i] = new FEIInventorySavesListLoadElement(tag.func_74779_i("name"), tag.func_74775_l("inventory"));
                }
                this.elements[this.elements.length - 1] = new FEIInventorySavesListNewElement();
            }
            catch (IOException e) {
                logger.error("Caught exception while reading saves from nbt:", (Throwable)e);
            }
        }
    }

    @Override
    public JsonObject save(Profile profile) {
        JsonData data = new JsonData();
        data.xPos = this.xPos;
        data.yPos = this.yPos;
        data.width = this.width;
        data.height = this.height;
        data.borderX = this.borderX;
        data.borderY = this.borderY;
        data.scrollDistance = this.scrollDistance;
        data.clickTimeThreshold = this.clickTimeThreshold;
        data.clickDistanceThreshold = this.clickDistanceThreshold;
        data.backgroundColor = this.backgroundColor;
        data.textColor = this.textColor;
        data.tooltipBackground = this.tooltipBackground;
        File nbtd = new File(profile.getSaveDir(), "Inventory Saves.nbt");
        try {
            nbtd.createNewFile();
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (ListGuiElement.ListElement element : this.elements) {
                if (!(element instanceof FEIInventorySavesListLoadElement)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("name", ((FEIInventorySavesListLoadElement)element).name);
                tag.func_74782_a("inventory", (NBTBase)((FEIInventorySavesListLoadElement)element).inventory);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("saves", (NBTBase)list);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(nbtd));
        }
        catch (IOException e) {
            logger.error("Caught exception while writing saves to nbt:", (Throwable)e);
        }
        return gson.toJsonTree((Object)data).getAsJsonObject();
    }

    @Override
    public String getUnlocalizedName() {
        return "fei.gui.override.list.inventorysaves";
    }

    @Override
    public void openConfigGui(GuiScreen parent, FEIGuiOverride fei) {
        parent.field_146297_k.func_147108_a((GuiScreen)new FEIInventorySavesListSettingsGUI(parent, this));
    }

    public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        super.drawGuiPost((IGuiElementsHandler)fei, gui, mouseX, mouseY);
        if (gui.func_146272_n() && this.inside(mouseX, mouseY)) {
            this.drawTooltip(gui.field_146297_k.field_71466_p, mouseX, mouseY, true, true, 4, this.textColor, this.tooltipBackground, true, new String[]{"fei.gui.override.list.inventorysaves.leftlick", "fei.gui.override.list.inventorysaves.rightclick", "fei.gui.override.list.inventorysaves.shiftleftclick", "fei.gui.override.list.inventorysaves.shiftrightclick"});
        }
    }

    public boolean handleMouseEventPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (this.edit != null) {
            if (down) {
                this.edit.editf.func_146192_a(mouseX, mouseY, key);
                if (!this.edit.editf.func_146206_l()) {
                    this.edit.name = this.edit.editf.func_146179_b();
                    this.edit.editf = null;
                    this.edit = null;
                    FEIGuiOverride.saveToCurrentProfile();
                    fei.looseFocus();
                }
            }
            return true;
        }
        return super.handleMouseEventPost((IGuiElementsHandler)fei, gui, mouseX, mouseY, down, key);
    }

    public boolean handleKeyboardEvent(FEIGuiOverride fei, GuiScreen gui, boolean down, int key, char c) {
        if (this.edit != null) {
            if (down) {
                this.edit.editf.func_146201_a(c, key);
            }
            return true;
        }
        return false;
    }

    public static class JsonData {
        private int xPos;
        private int yPos;
        private int width;
        private int height;
        private int borderX;
        private int borderY;
        private int scrollDistance;
        private int clickTimeThreshold;
        private int clickDistanceThreshold;
        private RGBA backgroundColor;
        private RGBA textColor;
        private boolean tooltipBackground;

        private JsonData() {
        }
    }

    public class FEIInventorySavesListNewElement
    extends ListGuiElement.ListElement {
        public FEIInventorySavesListNewElement() {
            super((ListGuiElement)FEIInventorySavesList.this);
        }

        public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
            new GuiButtonExt(0, x, relY, FEIInventorySavesList.this.width, FEIInventorySavesList.this.elementY, StatCollector.func_74838_a((String)"fei.gui.override.list.inventorysaves.new")).func_146112_a(gui.field_146297_k, mouseX, mouseY);
        }

        public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY, boolean down, int key) {
            if (down && key == 0 && this.inside(relY, mouseX, mouseY)) {
                FEIInventorySavesList.this.edit = new FEIInventorySavesListLoadElement("", new NBTTagCompound());
                FEIInventorySavesList.this.edit.editf = new GuiTextField(0, gui.field_146297_k.field_71466_p, x + FEIInventorySavesList.this.borderX * 2, relY + FEIInventorySavesList.this.borderY * 2, FEIInventorySavesList.this.width - FEIInventorySavesList.this.borderX * 4, FEIInventorySavesList.this.elementY - FEIInventorySavesList.this.borderY * 4);
                FEIInventorySavesList.this.edit.editf.func_146195_b(true);
                FEIInventorySavesList.this.edit.load();
                FEIInventorySavesList.this.add(FEIInventorySavesList.this.edit, index);
                fei.setFocused((IGuiElement<FEIGuiOverride>)FEIInventorySavesList.this);
                return true;
            }
            return false;
        }
    }

    public class FEIInventorySavesListLoadElement
    extends ListGuiElement.ListElement {
        private String name;
        private NBTTagCompound inventory;
        private GuiTextField editf;

        public FEIInventorySavesListLoadElement(String name, NBTTagCompound inventory) {
            super((ListGuiElement)FEIInventorySavesList.this);
            this.name = name;
            this.inventory = inventory;
        }

        public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
            GuiButtonExt button = this == FEIInventorySavesList.this.edit ? new GuiButtonExt(0, x, relY, FEIInventorySavesList.this.width, FEIInventorySavesList.this.elementY, "") : new GuiButtonExt(0, x, relY, FEIInventorySavesList.this.width, FEIInventorySavesList.this.elementY, this.name);
            button.field_146124_l = FEIPermissionsManager.getPermissionLevels((EntityPlayer)Minecraft.func_71410_x().field_71439_g).isHigherOrEqual(FEIPermissionLevel.MODERATOR);
            button.func_146112_a(gui.field_146297_k, mouseX, mouseY);
            if (this == FEIInventorySavesList.this.edit) {
                this.editf.func_146194_f();
            }
        }

        public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY, boolean down, int key) {
            if (down && this.inside(relY, mouseX, mouseY)) {
                if (key == 0) {
                    if (!gui.func_146272_n()) {
                        ForeverEnoughItemsBase.net.sendToServer((IMessage)new LoadInventoryPacket(this.inventory));
                    } else if (FEIPermissionsManager.getPermissionLevels((EntityPlayer)Minecraft.func_71410_x().field_71439_g).isHigherOrEqual(FEIPermissionLevel.MODERATOR)) {
                        this.load();
                    }
                    return true;
                }
                if (key == 1) {
                    if (!gui.func_146272_n()) {
                        this.editf = new GuiTextField(0, gui.field_146297_k.field_71466_p, x + FEIInventorySavesList.this.borderX * 2, relY + FEIInventorySavesList.this.borderY * 2, FEIInventorySavesList.this.width - FEIInventorySavesList.this.borderX * 4, FEIInventorySavesList.this.elementY - FEIInventorySavesList.this.borderY * 4);
                        this.editf.func_146180_a(this.name);
                        this.editf.func_146195_b(true);
                        FEIInventorySavesList.this.edit = this;
                        fei.setFocused((IGuiElement<FEIGuiOverride>)FEIInventorySavesList.this);
                    } else {
                        FEIInventorySavesList.this.remove(index);
                        FEIInventorySavesList.this.checkScrollDistance();
                    }
                    FEIGuiOverride.saveToCurrentProfile();
                    return true;
                }
            }
            return false;
        }

        public void load() {
            MinecraftForge.EVENT_BUS.post((Event)new FEIInventorySaveEvent((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.inventory));
            FEIGuiOverride.saveToCurrentProfile();
        }
    }
}

