/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.shape3d;

import code.elix_x.excore.utils.pos.BlockPos;
import code.elix_x.excore.utils.shape3d.AxisAlignedBox;
import code.elix_x.excore.utils.shape3d.Shape3D;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Sphere
extends Shape3D {
    protected double radius;
    protected AxisAlignedBox box;

    private Sphere() {
        super(0.0, 0.0, 0.0);
    }

    public Sphere(double posX, double posY, double posZ, double range) {
        super(posX, posY, posZ);
        this.radius = range;
        this.box = new AxisAlignedBox(posX - range, posY - range, posZ - range, posX + range, posY + range, posZ + range);
    }

    @Override
    public AxisAlignedBox getBounds() {
        return this.box;
    }

    @Override
    public Set<BlockPos> getAffectedBlocks(World world) {
        return this.getAffectedBlocks(world, this.box.getAffectedBlocks(world));
    }

    @Override
    public <E extends Entity> Set<E> getAffectedEntities(World world, Class<E> clazz) {
        return this.getAffectedEntities(world, this.box.getAffectedEntities(world, clazz), clazz);
    }

    @Override
    public Set<BlockPos> getAffectedBlocks(World world, Set<BlockPos> set) {
        HashSet<BlockPos> sset = new HashSet<BlockPos>();
        double range2 = this.radius * this.radius;
        for (BlockPos pos : set) {
            if (!(this.getPos().func_72436_e(pos.toVec3()) <= range2)) continue;
            sset.add(pos);
        }
        return sset;
    }

    @Override
    public <E extends Entity> Set<E> getAffectedEntities(World world, Set<E> set, Class<E> clazz) {
        HashSet<Entity> sset = new HashSet<Entity>();
        double range2 = this.radius * this.radius;
        for (Entity entity : set) {
            if (!(entity.func_70092_e(this.posX, this.posY, this.posZ) <= range2)) continue;
            sset.add(entity);
        }
        return sset;
    }

    @Override
    public boolean isInside(World world, Vec3 vec) {
        return this.getPos().func_72436_e(vec) <= this.radius * this.radius;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sphere other = (Sphere)obj;
        return Double.doubleToLongBits(this.radius) == Double.doubleToLongBits(other.radius);
    }
}

